/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class RSAKeyLoader {
    private String path;
    private PrivateKey priKey;

    public RSAKeyLoader(String configHome) {
        this.path = configHome.equals("") ? "config" + System.getProperty("file.separator") + "keys" + System.getProperty("file.separator") : String.valueOf(configHome) + System.getProperty("file.separator") + "keys" + System.getProperty("file.separator");
    }

    public PublicKey loadPublicKey() throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(String.valueOf(this.path) + "publickey"));
        String tmp = "";
        String key = "";
        while ((tmp = r.readLine()) != null) {
            key = String.valueOf(key) + tmp;
        }
        r.close();
        PublicKey ret = this.getPublicKeyFromString(key);
        return ret;
    }

    public PrivateKey loadPrivateKey() throws Exception {
        if (this.priKey == null) {
            BufferedReader r = new BufferedReader(new FileReader(String.valueOf(this.path) + "privatekey"));
            String tmp = "";
            String key = "";
            while ((tmp = r.readLine()) != null) {
                key = String.valueOf(key) + tmp;
            }
            r.close();
            this.priKey = this.getPrivateKeyFromString(key);
        }
        return this.priKey;
    }

    private PrivateKey getPrivateKeyFromString(String key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)key));
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return privateKey;
    }

    private PublicKey getPublicKeyFromString(String key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)key));
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return publicKey;
    }
}

