/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration;

import bftsmart.communication.server.ServerConnection;
import bftsmart.reconfiguration.Reconfiguration;
import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.reconfiguration.StatusReply;
import bftsmart.reconfiguration.TTPMessage;
import bftsmart.reconfiguration.views.View;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TTP {
    private int id;
    private Reconfiguration rec = null;
    private ServerViewManager manager;
    private List<Integer> addIds = new LinkedList<Integer>();

    public TTP() {
        this("");
    }

    public TTP(String configHome) {
        this.id = this.loadID(configHome);
        this.manager = new ServerViewManager(this.id, configHome);
        this.rec = new Reconfiguration(this.id);
    }

    public void connect() {
        this.rec.connect();
    }

    private int loadID(String configHome) {
        try {
            String path = "";
            String sep = System.getProperty("file.separator");
            path = configHome == null || configHome.equals("") ? "config" + sep + "system.config" : String.valueOf(configHome) + sep + "system.config";
            FileReader fr = new FileReader(path);
            BufferedReader rd = new BufferedReader(fr);
            String line = null;
            while ((line = rd.readLine()) != null) {
                StringTokenizer str;
                if (line.startsWith("#") || (str = new StringTokenizer(line, "=")).countTokens() <= 1 || !str.nextToken().trim().equals("system.ttp.id")) continue;
                fr.close();
                rd.close();
                return Integer.parseInt(str.nextToken().trim());
            }
            fr.close();
            rd.close();
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return -1;
        }
    }

    public void addServer(int id, String ip, int port) {
        this.manager.getStaticConf().addHostInfo(id, ip, port);
        this.rec.addServer(id, ip, port);
        this.addIds.add(id);
    }

    public void removeServer(int id) {
        this.rec.removeServer(id);
    }

    public void setF(int f) {
        this.rec.setF(f);
    }

    public void executeUpdates() {
        this.connect();
        ReconfigureReply r = this.rec.execute();
        View v = r.getView();
        System.out.println("New view f: " + v.getF());
        TTPMessage msg = new TTPMessage(this.id, r);
        if (this.addIds.size() > 0) {
            this.sendResponse(this.addIds.toArray(new Integer[1]), msg);
            this.addIds.clear();
        }
    }

    private ServerConnection getConnection(int remoteId) {
        return new ServerConnection(this.manager, null, remoteId, null, null);
    }

    public void sendResponse(Integer[] targets, TTPMessage sm) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(bOut).writeObject(sm);
        }
        catch (IOException ex) {
            Logger.getLogger(ServerConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        byte[] data = bOut.toByteArray();
        Integer[] integerArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i = integerArray[n2];
            try {
                if (i != this.id) {
                    this.getConnection(i).send(data, true);
                }
            }
            catch (InterruptedException ex) {
                System.err.println(ex);
            }
            ++n2;
        }
    }

    public void close() {
        this.rec.close();
    }

    public static void main(String[] args) {
        TTP ttp = null;
        ttp = args.length > 0 ? new TTP(args[0]) : new TTP("");
        Scanner scan = new Scanner(System.in);
        String str = null;
        do {
            str = scan.nextLine();
            String cmd = "";
            int arg = -1;
            try {
                StringTokenizer token = new StringTokenizer(str);
                cmd = token.nextToken();
                arg = Integer.parseInt(token.nextToken());
            }
            catch (Exception token) {
                // empty catch block
            }
            if (arg < 0) continue;
            if (cmd.equals("add")) {
                int port = arg * 10 + 11000;
                ttp.addServer(arg, "127.0.0.1", port);
            } else if (cmd.equals("rem")) {
                ttp.removeServer(arg);
            }
            ttp.executeUpdates();
        } while (!str.equals("exit"));
        ttp.close();
        System.exit(0);
    }

    public StatusReply askStatus(int id) {
        this.connect();
        StatusReply reply = this.rec.askStatus(id);
        this.close();
        return reply;
    }
}

