/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration;

import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.ReconfigureRequest;
import bftsmart.reconfiguration.ViewManager;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ServerViewManager
extends ViewManager {
    public static final int ADD_SERVER = 0;
    public static final int REMOVE_SERVER = 1;
    public static final int CHANGE_F = 2;
    private int quorumF;
    private int quorum2F;
    private int quorumStrong;
    private int quorumCFT_Strong;
    private int quorumFastDecide;
    private int[] otherProcesses;
    private int[] lastJoinStet;
    private List<TOMMessage> updates = new LinkedList<TOMMessage>();
    private TOMLayer tomLayer;

    public ServerViewManager(int procId) {
        this(procId, "");
    }

    public ServerViewManager(int procId, String configHome) {
        super(procId, configHome);
        View cv = this.getViewStore().readView();
        if (cv == null) {
            this.reconfigureTo(new View(0, this.getStaticConf().getInitialView(), this.getStaticConf().getF(), this.getInitAdddresses()));
        } else {
            this.reconfigureTo(cv);
        }
    }

    private InetSocketAddress[] getInitAdddresses() {
        int[] nextV = this.getStaticConf().getInitialView();
        InetSocketAddress[] addresses = new InetSocketAddress[nextV.length];
        int i = 0;
        while (i < nextV.length) {
            addresses[i] = this.getStaticConf().getRemoteAddress(nextV[i]);
            ++i;
        }
        return addresses;
    }

    public void setTomLayer(TOMLayer tomLayer) {
        this.tomLayer = tomLayer;
    }

    public boolean isInCurrentView() {
        return this.currentView.isMember(this.getStaticConf().getProcessId());
    }

    public int[] getCurrentViewOtherAcceptors() {
        return this.otherProcesses;
    }

    public int[] getCurrentViewAcceptors() {
        return this.currentView.getProcesses();
    }

    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    public void enqueueUpdate(TOMMessage up) {
        ReconfigureRequest request = (ReconfigureRequest)TOMUtil.getObject(up.getContent());
        if (TOMUtil.verifySignature(this.getStaticConf().getRSAPublicKey(), request.toString().getBytes(), request.getSignature())) {
            if (request.getSender() == this.getStaticConf().getTTPId()) {
                this.updates.add(up);
            } else {
                boolean add = true;
                for (int key : request.getProperties().keySet()) {
                    String value = request.getProperties().get(key);
                    if (key == 0) {
                        StringTokenizer str = new StringTokenizer(value, ":");
                        if (str.countTokens() > 2) {
                            int id = Integer.parseInt(str.nextToken());
                            if (id == request.getSender()) continue;
                            add = false;
                            continue;
                        }
                        add = false;
                        continue;
                    }
                    if (key == 1) {
                        if (this.isCurrentViewMember(Integer.parseInt(value))) {
                            if (Integer.parseInt(value) == request.getSender()) continue;
                            add = false;
                            continue;
                        }
                        add = false;
                        continue;
                    }
                    if (key != 2) continue;
                    add = false;
                }
                if (add) {
                    this.updates.add(up);
                }
            }
        }
    }

    public byte[] executeUpdates(int eid, int decisionRound) {
        LinkedList<Integer> jSet = new LinkedList<Integer>();
        LinkedList<Integer> rSet = new LinkedList<Integer>();
        int f = -1;
        LinkedList<String> jSetInfo = new LinkedList<String>();
        int i = 0;
        while (i < this.updates.size()) {
            ReconfigureRequest request = (ReconfigureRequest)TOMUtil.getObject(this.updates.get(i).getContent());
            for (int key : request.getProperties().keySet()) {
                String value = request.getProperties().get(key);
                if (key == 0) {
                    int id;
                    StringTokenizer str = new StringTokenizer(value, ":");
                    if (str.countTokens() <= 2 || this.isCurrentViewMember(id = Integer.parseInt(str.nextToken())) || this.contains(id, jSet)) continue;
                    jSetInfo.add(value);
                    jSet.add(id);
                    String host = str.nextToken();
                    int port = Integer.valueOf(str.nextToken());
                    this.getStaticConf().addHostInfo(id, host, port);
                    continue;
                }
                if (key == 1) {
                    if (!this.isCurrentViewMember(Integer.parseInt(value))) continue;
                    rSet.add(Integer.parseInt(value));
                    continue;
                }
                if (key != 2) continue;
                f = Integer.parseInt(value);
            }
            ++i;
        }
        return this.reconfigure(jSetInfo, jSet, rSet, f, eid, decisionRound);
    }

    private boolean contains(int id, List<Integer> list) {
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == id) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private byte[] reconfigure(List<String> jSetInfo, List<Integer> jSet, List<Integer> rSet, int f, int eid, int decisionRound) {
        this.lastJoinStet = new int[jSet.size()];
        int[] nextV = new int[this.currentView.getN() + jSet.size() - rSet.size()];
        int p = 0;
        boolean forceLC = false;
        int i = 0;
        while (i < jSet.size()) {
            this.lastJoinStet[i] = jSet.get(i);
            nextV[p++] = jSet.get(i);
            ++i;
        }
        i = 0;
        while (i < this.currentView.getProcesses().length) {
            if (!this.contains(this.currentView.getProcesses()[i], rSet)) {
                nextV[p++] = this.currentView.getProcesses()[i];
            } else if (this.tomLayer.lm.getCurrentLeader() == this.currentView.getProcesses()[i]) {
                forceLC = true;
            }
            ++i;
        }
        if (f < 0) {
            f = this.currentView.getF();
        }
        InetSocketAddress[] addresses = new InetSocketAddress[nextV.length];
        int i2 = 0;
        while (i2 < nextV.length) {
            addresses[i2] = this.getStaticConf().getRemoteAddress(nextV[i2]);
            ++i2;
        }
        View newV = new View(this.currentView.getId() + 1, nextV, f, addresses);
        System.out.println("new view: " + newV);
        System.out.println("installed on eid: " + eid);
        System.out.println("lastJoinSet: " + jSet);
        this.reconfigureTo(newV);
        if (forceLC) {
            System.out.println("Shortening LC timeout");
            this.tomLayer.requestsTimer.stopTimer();
            this.tomLayer.requestsTimer.setShortTimeout(3000L);
            this.tomLayer.requestsTimer.startTimer();
        }
        return TOMUtil.getBytes(new ReconfigureReply(newV, jSetInfo.toArray(new String[0]), eid, this.tomLayer.lm.getCurrentLeader()));
    }

    public TOMMessage[] clearUpdates() {
        TOMMessage[] ret = new TOMMessage[this.updates.size()];
        int i = 0;
        while (i < this.updates.size()) {
            ret[i] = this.updates.get(i);
            ++i;
        }
        this.updates.clear();
        return ret;
    }

    public boolean isInLastJoinSet(int id) {
        if (this.lastJoinStet != null) {
            int i = 0;
            while (i < this.lastJoinStet.length) {
                if (this.lastJoinStet[i] == id) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void processJoinResult(ReconfigureReply r) {
        this.reconfigureTo(r.getView());
        String[] s = r.getJoinSet();
        this.lastJoinStet = new int[s.length];
        int i = 0;
        while (i < s.length) {
            int id;
            StringTokenizer str = new StringTokenizer(s[i], ":");
            this.lastJoinStet[i] = id = Integer.parseInt(str.nextToken());
            String host = str.nextToken();
            int port = Integer.valueOf(str.nextToken());
            this.getStaticConf().addHostInfo(id, host, port);
            ++i;
        }
    }

    @Override
    public final void reconfigureTo(View newView) {
        this.currentView = newView;
        this.getViewStore().storeView(this.currentView);
        if (newView.isMember(this.getStaticConf().getProcessId())) {
            this.otherProcesses = new int[this.currentView.getProcesses().length - 1];
            int c = 0;
            int i = 0;
            while (i < this.currentView.getProcesses().length) {
                if (this.currentView.getProcesses()[i] != this.getStaticConf().getProcessId()) {
                    this.otherProcesses[c++] = this.currentView.getProcesses()[i];
                }
                ++i;
            }
            this.quorumF = this.currentView.getF();
            this.quorum2F = 2 * this.quorumF;
            this.quorumStrong = (int)Math.ceil((this.currentView.getN() + this.quorumF) / 2);
            this.quorumCFT_Strong = (int)Math.ceil(this.currentView.getN() / 2);
            this.quorumFastDecide = (int)Math.ceil((this.currentView.getN() + 3 * this.quorumF) / 2);
        } else if (this.currentView != null) {
            this.currentView.isMember(this.getStaticConf().getProcessId());
        }
    }

    public int getCertificateQuorum() {
        return this.getStaticConf().isBFT() ? this.quorum2F : this.quorumF;
    }

    public int getQuorumF() {
        return this.quorumF;
    }

    public int getQuorumFastDecide() {
        return this.quorumFastDecide;
    }

    public int getQuorumStrong() {
        return this.getStaticConf().isBFT() ? this.quorumStrong : this.quorumCFT_Strong;
    }
}

