/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration;

import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.ReconfigureRequest;
import bftsmart.reconfiguration.StatusReply;
import bftsmart.reconfiguration.StatusReplyListener;
import bftsmart.tom.ServiceProxy;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.TOMUtil;
import java.security.PrivateKey;

public class Reconfiguration {
    private ReconfigureRequest request;
    private ServiceProxy proxy;
    private int id;

    public Reconfiguration(int id) {
        this.id = id;
    }

    public void connect() {
        if (this.proxy == null) {
            this.proxy = new ServiceProxy(this.id);
        }
    }

    public void addServer(int id, String ip, int port) {
        this.setReconfiguration(0, String.valueOf(id) + ":" + ip + ":" + port);
    }

    public void removeServer(int id) {
        this.setReconfiguration(1, String.valueOf(id));
    }

    public void setF(int f) {
        this.setReconfiguration(2, String.valueOf(f));
    }

    public void setReconfiguration(int prop, String value) {
        if (this.request == null) {
            this.request = new ReconfigureRequest(this.id);
        }
        this.request.setProperty(prop, value);
    }

    public ReconfigureReply execute() {
        byte[] signature = TOMUtil.signMessage(this.proxy.getViewManager().getStaticConf().getRSAPrivateKey(), this.request.toString().getBytes());
        this.request.setSignature(signature);
        byte[] reply = this.proxy.invoke(TOMUtil.getBytes(this.request), TOMMessageType.RECONFIG);
        this.request = null;
        return (ReconfigureReply)TOMUtil.getObject(reply);
    }

    protected StatusReply askStatus(int id) {
        this.request = new ReconfigureRequest(id);
        PrivateKey key = this.proxy.getViewManager().getStaticConf().getRSAPrivateKey();
        byte[] reqBytes = this.request.toString().getBytes();
        byte[] signature = TOMUtil.signMessage(key, reqBytes);
        this.request.setSignature(signature);
        StatusReplyListener listener = new StatusReplyListener();
        this.proxy.invokeAsynchronous(TOMUtil.getBytes(this.request), listener, new int[]{id}, TOMMessageType.ASK_STATUS);
        StatusReply status = listener.getResponse();
        return status;
    }

    public void close() {
        this.proxy.close();
        this.proxy = null;
    }
}

