/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.paxosatwar.roles;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.paxosatwar.executionmanager.Execution;
import bftsmart.paxosatwar.executionmanager.ExecutionManager;
import bftsmart.paxosatwar.executionmanager.LeaderModule;
import bftsmart.paxosatwar.executionmanager.Round;
import bftsmart.paxosatwar.messages.MessageFactory;
import bftsmart.paxosatwar.messages.PaxosMessage;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public final class Acceptor {
    private int me;
    private ExecutionManager executionManager;
    private MessageFactory factory;
    private ServerCommunicationSystem communication;
    private LeaderModule leaderModule;
    private TOMLayer tomLayer;
    private ServerViewManager reconfManager;
    private Cipher cipher;

    public Acceptor(ServerCommunicationSystem communication, MessageFactory factory, LeaderModule lm, ServerViewManager manager) {
        this.communication = communication;
        this.me = manager.getStaticConf().getProcessId();
        this.factory = factory;
        this.leaderModule = lm;
        this.reconfManager = manager;
        try {
            this.cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            ex.printStackTrace();
        }
    }

    public MessageFactory getFactory() {
        return this.factory;
    }

    public void setExecutionManager(ExecutionManager manager) {
        this.executionManager = manager;
    }

    public void setTOMLayer(TOMLayer tom) {
        this.tomLayer = tom;
    }

    public final void deliver(PaxosMessage msg) {
        if (this.executionManager.checkLimits(msg)) {
            Logger.println("processing paxos msg with id " + msg.getNumber());
            this.processMessage(msg);
        } else {
            Logger.println("out of context msg with id " + msg.getNumber());
            this.tomLayer.processOutOfContext();
        }
    }

    public final void processMessage(PaxosMessage msg) {
        Execution execution = this.executionManager.getExecution(msg.getNumber());
        execution.lock.lock();
        Round round = execution.getRound(msg.getRound(), this.reconfManager);
        switch (msg.getPaxosType()) {
            case 44781: {
                this.proposeReceived(round, msg);
                break;
            }
            case 44782: {
                this.weakAcceptReceived(round, msg.getSender(), msg.getValue());
                break;
            }
            case 44783: {
                this.strongAcceptReceived(round, msg);
            }
        }
        execution.lock.unlock();
    }

    public void proposeReceived(Round round, PaxosMessage msg) {
        int eid = round.getExecution().getId();
        Logger.println("(Acceptor.proposeReceived) PROPOSE for consensus " + eid);
        if (msg.getSender() == this.leaderModule.getCurrentLeader()) {
            this.executePropose(round, msg.getValue());
        } else {
            Logger.println("Propose received is not from the expected leader");
        }
    }

    private void executePropose(Round round, byte[] value) {
        int eid = round.getExecution().getId();
        Logger.println("(Acceptor.executePropose) executing propose for " + eid + "," + round.getNumber());
        long consensusStartTime = System.nanoTime();
        if (round.propValue == null) {
            round.propValue = value;
            round.propValueHash = this.tomLayer.computeHash(value);
            round.getExecution().addWritten(value);
            if (eid == this.tomLayer.getLastExec() + 1) {
                this.tomLayer.setInExec(eid);
            }
            round.deserializedPropValue = this.tomLayer.checkProposedValue(value, true);
            if (round.deserializedPropValue != null && !round.isWeakSetted(this.me)) {
                if (round.getExecution().getLearner().firstMessageProposed == null) {
                    round.getExecution().getLearner().firstMessageProposed = round.deserializedPropValue[0];
                }
                if (round.getExecution().getLearner().firstMessageProposed.consensusStartTime == 0L) {
                    round.getExecution().getLearner().firstMessageProposed.consensusStartTime = consensusStartTime;
                }
                round.getExecution().getLearner().firstMessageProposed.proposeReceivedTime = System.nanoTime();
                if (this.reconfManager.getStaticConf().isBFT()) {
                    Logger.println("(Acceptor.executePropose) sending weak for " + eid);
                    round.setWeak(this.me, round.propValueHash);
                    round.getExecution().getLearner().firstMessageProposed.weakSentTime = System.nanoTime();
                    this.communication.send(this.reconfManager.getCurrentViewOtherAcceptors(), this.factory.createWeak(eid, round.getNumber(), round.propValueHash));
                    Logger.println("(Acceptor.executePropose) weak sent for " + eid);
                    this.computeWeak(eid, round, round.propValueHash);
                    Logger.println("(Acceptor.executePropose) weak computed for " + eid);
                } else {
                    round.setStrong(this.me, round.propValueHash);
                    round.getExecution().getLearner().firstMessageProposed.weakSentTime = System.nanoTime();
                    round.getExecution().getLearner().firstMessageProposed.strongSentTime = System.nanoTime();
                    round.getExecution().setQuorumWeaks(round.propValueHash);
                    this.communication.send(this.reconfManager.getCurrentViewOtherAcceptors(), this.factory.createStrong(eid, round.getNumber(), round.propValueHash));
                    this.computeStrong(eid, round, round.propValueHash);
                }
                this.executionManager.processOutOfContext(round.getExecution());
            }
        }
    }

    private void weakAcceptReceived(Round round, int a, byte[] value) {
        int eid = round.getExecution().getId();
        Logger.println("(Acceptor.weakAcceptReceived) WEAK from " + a + " for consensus " + eid);
        round.setWeak(a, value);
        this.computeWeak(eid, round, value);
    }

    private void computeWeak(int eid, Round round, byte[] value) {
        int weakAccepted = round.countWeak(value);
        Logger.println("(Acceptor.computeWeak) I have " + weakAccepted + " weaks for " + eid + "," + round.getNumber());
        if (weakAccepted > this.reconfManager.getQuorumStrong() && Arrays.equals(value, round.propValueHash) && !round.isStrongSetted(this.me)) {
            Logger.println("(Acceptor.computeWeak) sending STRONG for " + eid);
            round.getExecution().setQuorumWeaks(value);
            round.setStrong(this.me, value);
            if (round.getExecution().getLearner().firstMessageProposed != null) {
                round.getExecution().getLearner().firstMessageProposed.strongSentTime = System.nanoTime();
            }
            PaxosMessage pm = this.factory.createStrong(eid, round.getNumber(), value);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
            try {
                new ObjectOutputStream(bOut).writeObject(pm);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            byte[] data = bOut.toByteArray();
            byte[] hash = this.tomLayer.computeHash(data);
            int[] processes = this.reconfManager.getCurrentViewAcceptors();
            HashMap<Integer, byte[]> macVector = new HashMap<Integer, byte[]>();
            int[] nArray = processes;
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                try {
                    SecretKeySpec key = new SecretKeySpec(this.communication.getServersConn().getSecretKey(id).getEncoded(), "DES");
                    this.cipher.init(1, key);
                    macVector.put(id, this.cipher.doFinal(hash));
                }
                catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
                    ex.printStackTrace();
                }
                ++n2;
            }
            pm.setMACVector(macVector);
            int[] targets = this.reconfManager.getCurrentViewOtherAcceptors();
            this.communication.getServersConn().send(targets, pm, true);
            round.addToProof(pm);
            this.computeStrong(eid, round, value);
        }
    }

    private void strongAcceptReceived(Round round, PaxosMessage msg) {
        int eid = round.getExecution().getId();
        Logger.println("(Acceptor.strongAcceptReceived) STRONG from " + msg.getSender() + " for consensus " + eid);
        round.setStrong(msg.getSender(), msg.getValue());
        round.addToProof(msg);
        this.computeStrong(eid, round, msg.getValue());
    }

    private void computeStrong(int eid, Round round, byte[] value) {
        Logger.println("(Acceptor.computeStrong) I have " + round.countStrong(value) + " strongs for " + eid + "," + round.getNumber());
        if (round.countStrong(value) > this.reconfManager.getCertificateQuorum() && !round.getExecution().isDecided()) {
            Logger.println("(Acceptor.computeStrong) Deciding " + eid);
            this.decide(round, value);
        }
    }

    private void decide(Round round, byte[] value) {
        if (round.getExecution().getLearner().firstMessageProposed != null) {
            round.getExecution().getLearner().firstMessageProposed.decisionTime = System.nanoTime();
        }
        this.leaderModule.decided(round.getExecution().getId(), this.tomLayer.lm.getCurrentLeader());
        round.getExecution().decided(round, value);
    }
}

