/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.paxosatwar.messages;

import bftsmart.communication.SystemMessage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PaxosMessage
extends SystemMessage {
    private int number;
    private int round;
    private int paxosType;
    private byte[] value = null;
    private Object macVector;

    public PaxosMessage() {
    }

    public PaxosMessage(int paxosType, int id, int round, int from, byte[] value, Object proof) {
        super(from);
        this.paxosType = paxosType;
        this.number = id;
        this.round = round;
        this.value = value;
        this.macVector = proof;
    }

    public PaxosMessage(int paxosType, int id, int round, int from, byte[] value) {
        this(paxosType, id, round, from, value, null);
    }

    public PaxosMessage(int paxosType, int id, int round, int from) {
        this(paxosType, id, round, from, null, null);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.number);
        out.writeInt(this.round);
        out.writeInt(this.paxosType);
        if (this.value == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.value.length);
            out.write(this.value);
        }
        if (this.paxosType == 44783 || this.paxosType == 44786) {
            out.writeObject(this.macVector);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.number = in.readInt();
        this.round = in.readInt();
        this.paxosType = in.readInt();
        int toRead = in.readInt();
        if (toRead != -1) {
            this.value = new byte[toRead];
            while ((toRead -= in.read(this.value, this.value.length - toRead, toRead)) > 0) {
            }
        }
        if (this.paxosType == 44783) {
            this.macVector = in.readObject();
        }
    }

    public int getRound() {
        return this.round;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setMACVector(Object proof) {
        this.macVector = proof;
    }

    public Object getMACVector() {
        return this.macVector;
    }

    public int getNumber() {
        return this.number;
    }

    public int getPaxosType() {
        return this.paxosType;
    }

    public String getPaxosVerboseType() {
        if (this.paxosType == 44781) {
            return "PROPOSE";
        }
        if (this.paxosType == 44783) {
            return "STRONG";
        }
        if (this.paxosType == 44782) {
            return "WEAK";
        }
        return "";
    }

    public String toString() {
        return "type=" + this.getPaxosVerboseType() + ", number=" + this.getNumber() + ", round=" + this.getRound() + ", from=" + this.getSender();
    }
}

