/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.paxosatwar.executionmanager;

import bftsmart.paxosatwar.executionmanager.Execution;
import bftsmart.paxosatwar.messages.PaxosMessage;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.core.messages.TOMMessage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;

public class Round
implements Serializable {
    private static final long serialVersionUID = -2891450035863688295L;
    private transient Execution execution;
    private int number;
    private int me;
    private boolean[] weakSetted;
    private boolean[] strongSetted;
    private byte[][] weak;
    private byte[][] strong;
    private Collection<Integer> freeze = null;
    private boolean frozen = false;
    private boolean collected = false;
    private boolean alreadyRemoved = false;
    public byte[] propValue = null;
    public TOMMessage[] deserializedPropValue = null;
    public byte[] propValueHash = null;
    public HashSet<PaxosMessage> proof;
    private View lastView = null;
    private ServerViewManager manager;

    protected Round(ServerViewManager manager, Execution parent, int number) {
        this.execution = parent;
        this.number = number;
        this.manager = manager;
        this.proof = new HashSet();
        this.lastView = manager.getCurrentView();
        this.me = manager.getStaticConf().getProcessId();
        int n = manager.getCurrentViewN();
        this.weakSetted = new boolean[n];
        this.strongSetted = new boolean[n];
        Arrays.fill(this.weakSetted, false);
        Arrays.fill(this.strongSetted, false);
        if (number == 0) {
            this.weak = new byte[n][];
            this.strong = new byte[n][];
            Arrays.fill((Object[])this.weak, null);
            Arrays.fill((Object[])this.strong, null);
        } else {
            Round previousRound = this.execution.getRound(number - 1, manager);
            this.weak = previousRound.getWeak();
            this.strong = previousRound.getStrong();
        }
    }

    private void updateArrays() {
        if (this.lastView.getId() != this.manager.getCurrentViewId()) {
            int n = this.manager.getCurrentViewN();
            byte[][] weak = new byte[n][];
            byte[][] strong = new byte[n][];
            boolean[] weakSetted = new boolean[n];
            boolean[] strongSetted = new boolean[n];
            Arrays.fill(weakSetted, false);
            Arrays.fill(strongSetted, false);
            int[] nArray = this.lastView.getProcesses();
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int pid = nArray[n3];
                if (this.manager.isCurrentViewMember(pid)) {
                    int currentPos = this.manager.getCurrentViewPos(pid);
                    int lastPos = this.lastView.getPos(pid);
                    weak[currentPos] = this.weak[lastPos];
                    strong[currentPos] = this.strong[lastPos];
                    weakSetted[currentPos] = this.weakSetted[lastPos];
                    strongSetted[currentPos] = this.strongSetted[lastPos];
                }
                ++n3;
            }
            this.weak = weak;
            this.strong = strong;
            this.weakSetted = weakSetted;
            this.strongSetted = strongSetted;
            this.lastView = this.manager.getCurrentView();
        }
    }

    public void setRemoved() {
        this.alreadyRemoved = true;
    }

    public boolean isRemoved() {
        return this.alreadyRemoved;
    }

    public void addToProof(PaxosMessage pm) {
        this.proof.add(pm);
    }

    public Set<PaxosMessage> getProof() {
        return this.proof;
    }

    public int getNumber() {
        return this.number;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public boolean isWeakSetted(int acceptor) {
        this.updateArrays();
        int p = this.manager.getCurrentViewPos(acceptor);
        if (p >= 0) {
            return this.weak[p] != null;
        }
        return false;
    }

    public boolean isStrongSetted(int acceptor) {
        this.updateArrays();
        int p = this.manager.getCurrentViewPos(acceptor);
        if (p >= 0) {
            return this.strong[p] != null;
        }
        return false;
    }

    public byte[] getWeak(int acceptor) {
        this.updateArrays();
        int p = this.manager.getCurrentViewPos(acceptor);
        if (p >= 0) {
            return this.weak[p];
        }
        return null;
    }

    public byte[][] getWeak() {
        return this.weak;
    }

    public void setWeak(int acceptor, byte[] value) {
        this.updateArrays();
        int p = this.manager.getCurrentViewPos(acceptor);
        if (p >= 0 && !this.isFrozen()) {
            this.weak[p] = value;
            this.weakSetted[p] = true;
        }
    }

    public byte[] getStrong(int acceptor) {
        this.updateArrays();
        int p = this.manager.getCurrentViewPos(acceptor);
        if (p >= 0) {
            return this.strong[p];
        }
        return null;
    }

    public byte[][] getStrong() {
        return this.strong;
    }

    public void setStrong(int acceptor, byte[] value) {
        this.updateArrays();
        int p = this.manager.getCurrentViewPos(acceptor);
        if (p >= 0 && !this.isFrozen()) {
            this.strong[p] = value;
            this.strongSetted[p] = true;
        }
    }

    public boolean isCollected() {
        return this.collected;
    }

    public void collect() {
        this.collected = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        this.frozen = true;
        this.addFreeze(this.me);
    }

    public void addFreeze(int acceptor) {
        if (this.freeze == null) {
            this.freeze = new TreeSet<Integer>();
        }
        this.freeze.add(acceptor);
    }

    public int countFreeze() {
        return this.freeze.size();
    }

    public int countWeak(byte[] value) {
        return this.count(this.weakSetted, this.weak, value);
    }

    public int countStrong(byte[] value) {
        return this.count(this.strongSetted, this.strong, value);
    }

    private int count(boolean[] arraySetted, byte[][] array, byte[] value) {
        if (value != null) {
            int counter = 0;
            int i = 0;
            while (i < array.length) {
                if (arraySetted != null && arraySetted[i] && Arrays.equals(value, array[i])) {
                    ++counter;
                }
                ++i;
            }
            return counter;
        }
        return 0;
    }

    public String toString() {
        StringBuffer buffWeak = new StringBuffer(1024);
        StringBuffer buffStrong = new StringBuffer(1024);
        StringBuffer buffDecide = new StringBuffer(1024);
        buffWeak.append("W=(");
        buffStrong.append("S=(");
        buffDecide.append("D=(");
        int i = 0;
        while (i < this.weak.length - 1) {
            buffWeak.append(String.valueOf(this.str(this.weak[i])) + " [" + (this.weak[i] != null ? this.weak[i].length : 0) + " bytes] ,");
            buffStrong.append(String.valueOf(this.str(this.strong[i])) + " [" + (this.strong[i] != null ? this.strong[i].length : 0) + " bytes] ,");
            ++i;
        }
        buffWeak.append(String.valueOf(this.str(this.weak[this.weak.length - 1])) + " [" + (this.weak[this.weak.length - 1] != null ? this.weak[this.weak.length - 1].length : 0) + " bytes])");
        buffStrong.append(String.valueOf(this.str(this.strong[this.strong.length - 1])) + " [" + (this.strong[this.strong.length - 1] != null ? this.strong[this.strong.length - 1].length : 0) + " bytes])");
        return "eid=" + this.execution.getId() + " r=" + this.getNumber() + " " + buffWeak + " " + buffStrong + " " + buffDecide;
    }

    private String str(byte[] obj) {
        if (obj == null) {
            return "*";
        }
        return Base64.encodeBase64String((byte[])obj);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public void clear() {
        int n = this.manager.getCurrentViewN();
        this.weakSetted = new boolean[n];
        this.strongSetted = new boolean[n];
        Arrays.fill(this.weakSetted, false);
        Arrays.fill(this.strongSetted, false);
        this.weak = new byte[n][];
        this.strong = new byte[n][];
        Arrays.fill((Object[])this.weak, null);
        Arrays.fill((Object[])this.strong, null);
        this.proof = new HashSet();
    }
}

