/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.paxosatwar.executionmanager;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class LeaderModule {
    private Map<Integer, List<ConsInfo>> leaderInfos = new HashMap<Integer, List<ConsInfo>>();
    private int currentLeader;
    private ReentrantLock leaderInfosLock = new ReentrantLock();

    public LeaderModule() {
        this.addLeaderInfo(-1, 0, 0);
        this.addLeaderInfo(0, 0, 0);
        this.currentLeader = 0;
    }

    public void addLeaderInfo(int c, int r, int l) {
        ConsInfo ci;
        List<ConsInfo> list = this.leaderInfos.get(c);
        if (list == null) {
            list = new LinkedList<ConsInfo>();
            this.leaderInfos.put(c, list);
        }
        if ((ci = this.findInfo(list, r)) != null) {
            ci.leaderId = l;
        } else {
            list.add(new ConsInfo(r, l));
        }
    }

    public void setNewLeader(int leader) {
        this.currentLeader = leader;
    }

    public int getCurrentLeader() {
        return this.currentLeader;
    }

    private ConsInfo findInfo(List<ConsInfo> l, int r) {
        ConsInfo ret = null;
        int i = 0;
        while (i < l.size()) {
            ret = l.get(i);
            if (ret.round == r) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public void decided(int c, int l) {
        if (this.leaderInfos.get(c) == null) {
            this.addLeaderInfo(c + 1, 0, l);
        }
    }

    public int getLeader(int c, int r) {
        List<ConsInfo> list = this.leaderInfos.get(c);
        if (list == null) {
            list = new LinkedList<ConsInfo>();
            this.leaderInfos.put(c, list);
            List<ConsInfo> before = this.leaderInfos.get(c - 1);
            if (before != null && before.size() > 0) {
                ConsInfo ci = before.get(before.size() - 1);
                list.add(new ConsInfo(r, ci.leaderId));
                return ci.leaderId;
            }
        } else {
            int i = 0;
            while (i < list.size()) {
                ConsInfo ci = list.get(i);
                if (ci.round == r) {
                    return ci.leaderId;
                }
                ++i;
            }
        }
        return -1;
    }

    public void removeStableConsenusInfos(int c) {
        this.leaderInfosLock.lock();
        this.leaderInfos.remove(c);
        this.leaderInfosLock.unlock();
    }

    public void removeStableMultipleConsenusInfos(int cStart, int cEnd) {
        this.leaderInfosLock.lock();
        List<ConsInfo> list = this.leaderInfos.get(cEnd + 1);
        if (list == null) {
            list = new LinkedList<ConsInfo>();
            this.leaderInfos.put(cEnd + 1, list);
            List<ConsInfo> rm = this.leaderInfos.get(cEnd);
            if (rm != null) {
                ConsInfo ci = rm.get(rm.size() - 1);
                list.add(new ConsInfo(0, ci.leaderId));
            }
        }
        int c = cStart;
        while (c <= cEnd) {
            this.leaderInfos.remove(c);
            ++c;
        }
        this.leaderInfosLock.unlock();
    }

    private class ConsInfo {
        public int round;
        public int leaderId;

        public ConsInfo(int r, int l) {
            this.round = r;
            this.leaderId = l;
        }
    }
}

