/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.paxosatwar.executionmanager;

import bftsmart.paxosatwar.Consensus;
import bftsmart.paxosatwar.executionmanager.Execution;
import bftsmart.paxosatwar.executionmanager.Round;
import bftsmart.paxosatwar.messages.PaxosMessage;
import bftsmart.paxosatwar.roles.Acceptor;
import bftsmart.paxosatwar.roles.Proposer;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.util.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;

public final class ExecutionManager {
    private ServerViewManager reconfManager;
    private Acceptor acceptor;
    private Proposer proposer;
    private Map<Integer, Execution> executions = new TreeMap<Integer, Execution>();
    private ReentrantLock executionsLock = new ReentrantLock();
    private Map<Integer, List<PaxosMessage>> outOfContext = new HashMap<Integer, List<PaxosMessage>>();
    private Map<Integer, PaxosMessage> outOfContextProposes = new HashMap<Integer, PaxosMessage>();
    private ReentrantLock outOfContextLock = new ReentrantLock();
    private boolean stopped = false;
    private Queue<PaxosMessage> stoppedMsgs = new LinkedList<PaxosMessage>();
    private Round stoppedRound = null;
    private ReentrantLock stoppedMsgsLock = new ReentrantLock();
    private TOMLayer tomLayer;
    private int paxosHighMark;
    private int revivalHighMark;
    private int timeoutHighMark;

    public ExecutionManager(ServerViewManager manager, Acceptor acceptor, Proposer proposer, int me) {
        this.reconfManager = manager;
        this.acceptor = acceptor;
        this.proposer = proposer;
        this.paxosHighMark = this.reconfManager.getStaticConf().getPaxosHighMark();
        this.revivalHighMark = this.reconfManager.getStaticConf().getRevivalHighMark();
        this.timeoutHighMark = this.reconfManager.getStaticConf().getTimeoutHighMark();
    }

    public void setTOMLayer(TOMLayer tom) {
        this.tomLayer = tom;
    }

    public TOMLayer getTOMLayer() {
        return this.tomLayer;
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public Proposer getProposer() {
        return this.proposer;
    }

    public boolean stopped() {
        return this.stopped;
    }

    public Queue<PaxosMessage> getStoppedMsgs() {
        return this.stoppedMsgs;
    }

    public void clearStopped() {
        this.stoppedMsgs.clear();
    }

    public void stop() {
        Logger.println("(ExecutionManager.stoping) Stoping execution manager");
        this.stoppedMsgsLock.lock();
        this.stopped = true;
        if (this.tomLayer.getInExec() != -1) {
            this.stoppedRound = this.getExecution(this.tomLayer.getInExec()).getLastRound();
            if (this.stoppedRound != null) {
                Logger.println("(ExecutionManager.stop) Stoping round " + this.stoppedRound.getNumber() + " of consensus " + this.tomLayer.getInExec());
            }
        }
        this.stoppedMsgsLock.unlock();
    }

    public void restart() {
        Logger.println("(ExecutionManager.restart) Starting execution manager");
        this.stoppedMsgsLock.lock();
        this.stopped = false;
        while (!this.stoppedMsgs.isEmpty()) {
            PaxosMessage pm = this.stoppedMsgs.remove();
            if (pm.getNumber() <= this.tomLayer.getLastExec()) continue;
            this.acceptor.processMessage(pm);
        }
        this.stoppedMsgsLock.unlock();
        Logger.println("(ExecutionManager.restart) Finished stopped messages processing");
    }

    public final boolean checkLimits(PaxosMessage msg) {
        this.outOfContextLock.lock();
        int lastConsId = this.tomLayer.getLastExec();
        int inExec = this.tomLayer.getInExec();
        Logger.println("(ExecutionManager.checkLimits) Received message  " + msg);
        Logger.println("(ExecutionManager.checkLimits) I'm at execution " + inExec + " and my last execution is " + lastConsId);
        boolean isRetrievingState = this.tomLayer.isRetrievingState();
        if (isRetrievingState) {
            Logger.println("(ExecutionManager.checkLimits) I'm waiting for a state");
        }
        boolean canProcessTheMessage = false;
        if (isRetrievingState || (lastConsId != -1 || msg.getNumber() < lastConsId + this.revivalHighMark) && msg.getNumber() > lastConsId && msg.getNumber() < lastConsId + this.paxosHighMark && (!this.stopped || msg.getNumber() < lastConsId + this.timeoutHighMark)) {
            if (this.stopped) {
                this.stoppedMsgsLock.lock();
                if (this.stopped) {
                    Logger.println("(ExecutionManager.checkLimits) adding message for execution " + msg.getNumber() + " to stoopped");
                    this.stoppedMsgs.add(msg);
                }
                this.stoppedMsgsLock.unlock();
            } else if (isRetrievingState || msg.getNumber() > lastConsId + 1 || inExec != -1 && inExec < msg.getNumber() || inExec == -1 && msg.getPaxosType() != 44781) {
                Logger.println("(ExecutionManager.checkLimits) Message for execution " + msg.getNumber() + " is out of context, adding it to out of context set");
                this.addOutOfContextMessage(msg);
            } else {
                Logger.println("(ExecutionManager.checkLimits) message for execution " + msg.getNumber() + " can be processed");
                canProcessTheMessage = true;
            }
        } else if (lastConsId == -1 && msg.getNumber() >= lastConsId + this.revivalHighMark || msg.getNumber() >= lastConsId + this.paxosHighMark || this.stopped && msg.getNumber() >= lastConsId + this.timeoutHighMark) {
            Logger.println("(ExecutionManager.checkLimits) Message for execution " + msg.getNumber() + " is beyond the paxos highmark, adding it to out of context set");
            this.addOutOfContextMessage(msg);
            if (this.reconfManager.getStaticConf().isStateTransferEnabled()) {
                this.tomLayer.getStateManager().analyzeState(msg.getNumber());
            } else {
                System.out.println("##################################################################################");
                System.out.println("- Ahead-of-time message discarded");
                System.out.println("- If many messages of the same consensus are discarded, the replica can halt!");
                System.out.println("- Try to increase the 'system.paxos.highMarc' configuration parameter.");
                System.out.println("- Last consensus executed: " + lastConsId);
                System.out.println("##################################################################################");
            }
        }
        this.outOfContextLock.unlock();
        return canProcessTheMessage;
    }

    public boolean receivedOutOfContextPropose(int eid) {
        this.outOfContextLock.lock();
        boolean result = this.outOfContextProposes.get(eid) != null;
        this.outOfContextLock.unlock();
        return result;
    }

    public Execution removeExecution(int id) {
        this.executionsLock.lock();
        Execution execution = this.executions.remove(id);
        this.executionsLock.unlock();
        this.outOfContextLock.lock();
        this.outOfContextProposes.remove(id);
        this.outOfContext.remove(id);
        this.outOfContextLock.unlock();
        return execution;
    }

    public void removeOutOfContexts(int id) {
        this.outOfContextLock.lock();
        Integer[] keys = new Integer[this.outOfContextProposes.keySet().size()];
        this.outOfContextProposes.keySet().toArray(keys);
        int i = 0;
        while (i < keys.length) {
            if (keys[i] <= id) {
                this.outOfContextProposes.remove(keys[i]);
            }
            ++i;
        }
        keys = new Integer[this.outOfContext.keySet().size()];
        this.outOfContext.keySet().toArray(keys);
        i = 0;
        while (i < keys.length) {
            if (keys[i] <= id) {
                this.outOfContext.remove(keys[i]);
            }
            ++i;
        }
        this.outOfContextLock.unlock();
    }

    public Execution getExecution(int eid) {
        this.executionsLock.lock();
        Execution execution = this.executions.get(eid);
        if (execution == null) {
            Consensus cons = new Consensus(eid);
            execution = new Execution(this, cons);
            this.executions.put(eid, execution);
        }
        this.executionsLock.unlock();
        return execution;
    }

    public boolean isDecidable(int eid) {
        if (this.receivedOutOfContextPropose(eid)) {
            Execution exec = this.getExecution(eid);
            PaxosMessage prop = this.outOfContextProposes.get(exec.getId());
            Round round = exec.getRound(prop.getRound(), this.reconfManager);
            byte[] propHash = this.tomLayer.computeHash(prop.getValue());
            List<PaxosMessage> msgs = this.outOfContext.get(eid);
            int countWeaks = 0;
            int countStrongs = 0;
            if (msgs != null) {
                for (PaxosMessage msg : msgs) {
                    if (msg.getRound() != round.getNumber() || !Arrays.equals(propHash, msg.getValue())) continue;
                    if (msg.getPaxosType() == 44782) {
                        ++countWeaks;
                        continue;
                    }
                    if (msg.getPaxosType() != 44783) continue;
                    ++countStrongs;
                }
            }
            if (this.reconfManager.getStaticConf().isBFT()) {
                return countWeaks > 2 * this.reconfManager.getCurrentViewF() && countStrongs > 2 * this.reconfManager.getCurrentViewF();
            }
            return countStrongs > this.reconfManager.getQuorumStrong();
        }
        return false;
    }

    public void processOutOfContextPropose(Execution execution) {
        this.outOfContextLock.lock();
        PaxosMessage prop = this.outOfContextProposes.remove(execution.getId());
        if (prop != null) {
            Logger.println("(ExecutionManager.createExecution) (" + execution.getId() + ") Processing out of context propose");
            this.acceptor.processMessage(prop);
        }
        this.outOfContextLock.unlock();
    }

    public void processOutOfContext(Execution execution) {
        this.outOfContextLock.lock();
        List<PaxosMessage> messages = this.outOfContext.remove(execution.getId());
        if (messages != null) {
            Logger.println("(createExecution) (" + execution.getId() + ") Processing other " + messages.size() + " out of context messages.");
            Iterator<PaxosMessage> i = messages.iterator();
            while (i.hasNext()) {
                this.acceptor.processMessage(i.next());
                if (!execution.isDecided()) continue;
                Logger.println("(ExecutionManager.createExecution) execution " + execution.getId() + " decided.");
                break;
            }
            Logger.println("(createExecution) (" + execution.getId() + ") Finished out of context processing");
        }
        this.outOfContextLock.unlock();
    }

    public void addOutOfContextMessage(PaxosMessage m) {
        this.outOfContextLock.lock();
        if (m.getPaxosType() == 44781) {
            Logger.println("(ExecutionManager.addOutOfContextMessage) adding " + m);
            this.outOfContextProposes.put(m.getNumber(), m);
        } else {
            List<PaxosMessage> messages = this.outOfContext.get(m.getNumber());
            if (messages == null) {
                messages = new LinkedList<PaxosMessage>();
                this.outOfContext.put(m.getNumber(), messages);
            }
            Logger.println("(ExecutionManager.addOutOfContextMessage) adding " + m);
            messages.add(m);
        }
        this.outOfContextLock.unlock();
    }

    public String toString() {
        return this.stoppedMsgs.toString();
    }
}

