/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.paxosatwar.executionmanager;

import bftsmart.paxosatwar.Consensus;
import bftsmart.paxosatwar.executionmanager.ExecutionManager;
import bftsmart.paxosatwar.executionmanager.Round;
import bftsmart.paxosatwar.executionmanager.TimestampValuePair;
import bftsmart.reconfiguration.ServerViewManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class Execution {
    private ExecutionManager manager;
    private Consensus consensus;
    private HashMap<Integer, Round> rounds = new HashMap(2);
    private ReentrantLock roundsLock = new ReentrantLock();
    private boolean decided;
    private int decisionRound = -1;
    private int ets = 0;
    private TimestampValuePair quorumWeaks = new TimestampValuePair(0, new byte[0]);
    private HashSet<TimestampValuePair> writeSet = new HashSet();
    public ReentrantLock lock = new ReentrantLock();

    protected Execution(ExecutionManager manager, Consensus consensus) {
        this.manager = manager;
        this.consensus = consensus;
    }

    public int getId() {
        return this.consensus.getId();
    }

    public ExecutionManager getManager() {
        return this.manager;
    }

    public Consensus getLearner() {
        return this.consensus;
    }

    public Round getRound(int number, ServerViewManager recManager) {
        return this.getRound(number, true, recManager);
    }

    public Round getRound(int number, boolean create, ServerViewManager recManager) {
        this.roundsLock.lock();
        Round round = this.rounds.get(number);
        if (round == null && create) {
            round = new Round(recManager, this, number);
            this.rounds.put(number, round);
        }
        this.roundsLock.unlock();
        return round;
    }

    public void incEts() {
        ++this.ets;
    }

    public void setQuorumWeaks(byte[] value) {
        this.quorumWeaks = new TimestampValuePair(this.ets, value);
    }

    public TimestampValuePair getQuorumWeaks() {
        return this.quorumWeaks;
    }

    public void addWritten(byte[] value) {
        this.writeSet.add(new TimestampValuePair(this.ets, value));
    }

    public void removeWritten(byte[] value) {
        for (TimestampValuePair rv : this.writeSet) {
            if (!Arrays.equals(rv.getValue(), value)) continue;
            this.writeSet.remove(rv);
        }
    }

    public HashSet<TimestampValuePair> getWriteSet() {
        return this.writeSet;
    }

    public Round createRound(ServerViewManager recManager) {
        this.roundsLock.lock();
        Set<Integer> keys = this.rounds.keySet();
        int max = -1;
        for (int k : keys) {
            if (k <= max) continue;
            max = k;
        }
        Round round = new Round(recManager, this, ++max);
        this.rounds.put(max, round);
        this.roundsLock.unlock();
        return round;
    }

    public void removeRounds(int limit) {
        this.roundsLock.lock();
        Integer[] integerArray = this.rounds.keySet().toArray(new Integer[0]);
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer key = integerArray[n2];
            if (key > limit) {
                Round round = this.rounds.remove(key);
                round.setRemoved();
            }
            ++n2;
        }
        this.roundsLock.unlock();
    }

    public Round getDecisionRound() {
        this.roundsLock.lock();
        Round r = this.rounds.get(this.decisionRound);
        this.roundsLock.unlock();
        return r;
    }

    public Round getLastRound() {
        this.roundsLock.lock();
        if (this.rounds.isEmpty()) {
            this.roundsLock.unlock();
            return null;
        }
        Round r = this.rounds.get(this.rounds.size() - 1);
        this.roundsLock.unlock();
        return r;
    }

    public boolean isDecided() {
        return this.decided;
    }

    public void decided(Round round, byte[] value) {
        if (!this.decided) {
            this.decided = true;
            this.decisionRound = round.getNumber();
            this.consensus.decided(round);
            this.manager.getTOMLayer().decided(this.consensus);
        }
    }
}

