/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.paxosatwar;

import bftsmart.paxosatwar.executionmanager.Round;
import bftsmart.tom.core.messages.TOMMessage;

public class Consensus {
    private int eid;
    private Round decisionRound = null;
    private byte[] decision = null;
    private TOMMessage[] deserializedDecision = null;
    public TOMMessage firstMessageProposed = null;
    public int batchSize = 0;

    public Consensus(int eid) {
        this.eid = eid;
    }

    public void decided(Round round) {
        this.decisionRound = round;
    }

    public Round getDecisionRound() {
        return this.decisionRound;
    }

    public byte[] getDecision() {
        while (this.decision == null) {
            this.waitForPropose();
            this.decision = this.decisionRound.propValue;
        }
        return this.decision;
    }

    public TOMMessage[] getDeserializedDecision() {
        while (this.deserializedDecision == null) {
            this.waitForPropose();
            this.deserializedDecision = this.decisionRound.deserializedPropValue;
        }
        return this.deserializedDecision;
    }

    public int getId() {
        return this.eid;
    }

    private void waitForPropose() {
        while (this.decisionRound == null && this.decisionRound.deserializedPropValue == null) {
            try {
                System.out.println("waiting for propose for " + this.eid);
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

