/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.random;

import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.Executable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.defaultservices.DefaultRecoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Scanner;

public final class RandomServer
extends DefaultRecoverable {
    private int value = 0;
    private int iterations = 0;
    private int id = -1;
    private long initialTime = -1L;
    private long currentTime = -1L;
    private ServiceReplica replica;
    private ReplicaContext replicaContext;

    public ServiceReplica getReplica() {
        return this.replica;
    }

    public void setReplica(ServiceReplica replica) {
        this.replica = replica;
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.replicaContext = replicaContext;
    }

    public RandomServer(int id) {
        this.replica = new ServiceReplica(id, this, this);
        this.id = id;
    }

    public RandomServer(int id, boolean join) {
        this.replica = new ServiceReplica(id, join, (Executable)this, (Recoverable)this);
        this.id = id;
    }

    public byte[] executeOrdered(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        try {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(command));
            int argument = input.readInt();
            int operator = input.readInt();
            System.out.println("(" + this.id + ")[server] Argument: " + argument);
            switch (operator) {
                case 0: {
                    this.value += argument;
                    System.out.println("(" + this.id + ")[server] Operator: +");
                    break;
                }
                case 1: {
                    this.value -= argument;
                    System.out.println("(" + this.id + ")[server] Operator: -");
                    break;
                }
                case 2: {
                    this.value *= argument;
                    System.out.println("(" + this.id + ")[server] Operator: *");
                    break;
                }
                case 3: {
                    this.value /= argument;
                    System.out.println("(" + this.id + ")[server] Operator: /");
                }
            }
            if (msgCtx != null) {
                System.out.println("(" + this.id + ")[server] (" + this.iterations + " / " + msgCtx.getConsensusId() + " / " + msgCtx.getRegency() + ") Current value: " + this.value);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(4);
            new DataOutputStream(out).writeInt(this.value);
            return out.toByteArray();
        }
        catch (IOException ex) {
            System.err.println("Invalid request received!");
            return new byte[0];
        }
    }

    @Override
    public byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        try {
            System.out.println("(" + this.id + ")[server] (" + this.iterations + " / " + msgCtx.getConsensusId() + ") Current value: " + this.value);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4);
            new DataOutputStream(out).writeInt(this.value);
            return out.toByteArray();
        }
        catch (IOException ex) {
            System.err.println("Never happens!");
            return new byte[0];
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Use: java RandomServer <processId>");
            System.exit(-1);
        }
        RandomServer replica = null;
        replica = args.length > 1 ? new RandomServer(Integer.parseInt(args[0]), Boolean.valueOf(args[1])) : new RandomServer(Integer.parseInt(args[0]));
        Scanner scan = new Scanner(System.in);
        String ln = scan.nextLine();
        if (ln != null) {
            replica.getReplica().leave();
        }
    }

    public byte[] getState() {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(this.value >>> offset & 0xFF);
            ++i;
        }
        return b;
    }

    public void setState(byte[] state) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (state[i] & 0xFF) << shift;
            ++i;
        }
        this.value = value;
    }

    @Override
    public void installSnapshot(byte[] state) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (state[i] & 0xFF) << shift;
            ++i;
        }
        this.value = value;
    }

    @Override
    public byte[] getSnapshot() {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(this.value >>> offset & 0xFF);
            ++i;
        }
        return b;
    }

    @Override
    public byte[][] appExecuteBatch(byte[][] commands, MessageContext[] msgCtxs) {
        byte[][] replies = new byte[commands.length][];
        int i = 0;
        while (i < commands.length) {
            replies[i] = this.executeOrdered(commands[i], msgCtxs != null ? msgCtxs[i] : null);
            ++i;
        }
        return replies;
    }
}

