/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.microbenchmarks;

import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.StandardStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.SingleExecutable;
import bftsmart.tom.util.Storage;

public final class ThroughputLatencyServer
implements SingleExecutable,
Recoverable {
    private int interval;
    private int replySize;
    private float maxTp = -1.0f;
    private boolean context;
    private byte[] state;
    private int iterations = 0;
    private long throughputMeasurementStartTime = System.currentTimeMillis();
    private Storage totalLatency = null;
    private Storage consensusLatency = null;
    private Storage preConsLatency = null;
    private Storage posConsLatency = null;
    private Storage proposeLatency = null;
    private Storage weakLatency = null;
    private Storage strongLatency = null;
    private ServiceReplica replica;
    private ReplicaContext replicaContext;
    private StateManager stateManager;

    public ThroughputLatencyServer(int id, int interval, int replySize, int stateSize, boolean context) {
        this.replica = new ServiceReplica(id, this, this);
        this.interval = interval;
        this.replySize = replySize;
        this.context = context;
        this.state = new byte[stateSize];
        int i = 0;
        while (i < stateSize) {
            this.state[i] = (byte)i;
            ++i;
        }
        this.totalLatency = new Storage(interval);
        this.consensusLatency = new Storage(interval);
        this.preConsLatency = new Storage(interval);
        this.posConsLatency = new Storage(interval);
        this.proposeLatency = new Storage(interval);
        this.weakLatency = new Storage(interval);
        this.strongLatency = new Storage(interval);
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.replicaContext = replicaContext;
    }

    @Override
    public byte[] executeOrdered(byte[] command, MessageContext msgCtx) {
        return this.execute(command, msgCtx);
    }

    @Override
    public byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        return this.execute(command, msgCtx);
    }

    public byte[] execute(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        if (msgCtx.getConsensusId() == -1) {
            return new byte[this.replySize];
        }
        this.totalLatency.store(msgCtx.getFirstInBatch().executedTime - msgCtx.getFirstInBatch().receptionTime);
        this.consensusLatency.store(msgCtx.getFirstInBatch().decisionTime - msgCtx.getFirstInBatch().consensusStartTime);
        this.preConsLatency.store(msgCtx.getFirstInBatch().consensusStartTime - msgCtx.getFirstInBatch().receptionTime);
        this.posConsLatency.store(msgCtx.getFirstInBatch().executedTime - msgCtx.getFirstInBatch().decisionTime);
        this.proposeLatency.store(msgCtx.getFirstInBatch().weakSentTime - msgCtx.getFirstInBatch().consensusStartTime);
        this.weakLatency.store(msgCtx.getFirstInBatch().strongSentTime - msgCtx.getFirstInBatch().weakSentTime);
        this.strongLatency.store(msgCtx.getFirstInBatch().decisionTime - msgCtx.getFirstInBatch().strongSentTime);
        float tp = -1.0f;
        if (this.iterations % this.interval == 0) {
            if (this.context) {
                System.out.println("--- (Context)  iterations: " + this.iterations + " // regency: " + msgCtx.getRegency() + " // consensus: " + msgCtx.getConsensusId() + " ---");
            }
            System.out.println("--- Measurements after " + this.iterations + " ops (" + this.interval + " samples) ---");
            tp = (float)(this.interval * 1000) / (float)(System.currentTimeMillis() - this.throughputMeasurementStartTime);
            if (tp > this.maxTp) {
                this.maxTp = tp;
            }
            System.out.println("Throughput = " + tp + " operations/sec (Maximum observed: " + this.maxTp + " ops/sec)");
            System.out.println("Total latency = " + this.totalLatency.getAverage(false) / 1000L + " (+/- " + (long)this.totalLatency.getDP(false) / 1000L + ") us ");
            this.totalLatency.reset();
            System.out.println("Consensus latency = " + this.consensusLatency.getAverage(false) / 1000L + " (+/- " + (long)this.consensusLatency.getDP(false) / 1000L + ") us ");
            this.consensusLatency.reset();
            System.out.println("Pre-consensus latency = " + this.preConsLatency.getAverage(false) / 1000L + " (+/- " + (long)this.preConsLatency.getDP(false) / 1000L + ") us ");
            this.preConsLatency.reset();
            System.out.println("Pos-consensus latency = " + this.posConsLatency.getAverage(false) / 1000L + " (+/- " + (long)this.posConsLatency.getDP(false) / 1000L + ") us ");
            this.posConsLatency.reset();
            System.out.println("Propose latency = " + this.proposeLatency.getAverage(false) / 1000L + " (+/- " + (long)this.proposeLatency.getDP(false) / 1000L + ") us ");
            this.proposeLatency.reset();
            System.out.println("Weak latency = " + this.weakLatency.getAverage(false) / 1000L + " (+/- " + (long)this.weakLatency.getDP(false) / 1000L + ") us ");
            this.weakLatency.reset();
            System.out.println("Strong latency = " + this.strongLatency.getAverage(false) / 1000L + " (+/- " + (long)this.strongLatency.getDP(false) / 1000L + ") us ");
            this.strongLatency.reset();
            this.throughputMeasurementStartTime = System.currentTimeMillis();
        }
        return new byte[this.replySize];
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage: ... ThroughputLatencyServer <processId> <measurement interval> <reply size> <state size> <context?>");
            System.exit(-1);
        }
        int processId = Integer.parseInt(args[0]);
        int interval = Integer.parseInt(args[1]);
        int replySize = Integer.parseInt(args[2]);
        int stateSize = Integer.parseInt(args[3]);
        boolean context = Boolean.parseBoolean(args[4]);
        new ThroughputLatencyServer(processId, interval, replySize, stateSize, context);
    }

    public byte[] getState() {
        return this.state;
    }

    public void setState(byte[] state) {
    }

    @Override
    public ApplicationState getState(int eid, boolean sendState) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int setState(ApplicationState state) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new StandardStateManager();
        }
        return this.stateManager;
    }
}

