/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.microbenchmarks;

import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.StandardStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.SingleExecutable;
import bftsmart.tom.util.Storage;

public class LatencyServer
implements SingleExecutable,
Recoverable {
    private int interval;
    private int hashs;
    private int replySize;
    private int iterations = 0;
    private Storage totalLatency = null;
    private Storage consensusLatency = null;
    private Storage preConsLatency = null;
    private Storage posConsLatency = null;
    private Storage proposeLatency = null;
    private Storage weakLatency = null;
    private Storage strongLatency = null;
    private ServiceReplica replica;
    private ReplicaContext replicaContext;
    private StateManager stateManager;

    public LatencyServer(int id, int interval, int hashs, int replySize) {
        this.replica = new ServiceReplica(id, this, this);
        this.interval = interval;
        this.hashs = hashs;
        this.replySize = replySize;
        this.totalLatency = new Storage(interval);
        this.consensusLatency = new Storage(interval);
        this.preConsLatency = new Storage(interval);
        this.posConsLatency = new Storage(interval);
        this.proposeLatency = new Storage(interval);
        this.weakLatency = new Storage(interval);
        this.strongLatency = new Storage(interval);
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.replicaContext = replicaContext;
    }

    @Override
    public byte[] executeOrdered(byte[] command, MessageContext msgCtx) {
        return this.execute(command, msgCtx);
    }

    @Override
    public byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        return this.execute(command, msgCtx);
    }

    public byte[] execute(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        if (msgCtx.getConsensusId() == -1) {
            return new byte[this.replySize];
        }
        this.totalLatency.store(msgCtx.getFirstInBatch().executedTime - msgCtx.getFirstInBatch().receptionTime);
        this.consensusLatency.store(msgCtx.getFirstInBatch().decisionTime - msgCtx.getFirstInBatch().consensusStartTime);
        this.preConsLatency.store(msgCtx.getFirstInBatch().consensusStartTime - msgCtx.getFirstInBatch().receptionTime);
        this.posConsLatency.store(msgCtx.getFirstInBatch().executedTime - msgCtx.getFirstInBatch().decisionTime);
        this.proposeLatency.store(msgCtx.getFirstInBatch().weakSentTime - msgCtx.getFirstInBatch().consensusStartTime);
        this.weakLatency.store(msgCtx.getFirstInBatch().strongSentTime - msgCtx.getFirstInBatch().weakSentTime);
        this.strongLatency.store(msgCtx.getFirstInBatch().decisionTime - msgCtx.getFirstInBatch().strongSentTime);
        if (this.iterations % this.interval == 0) {
            System.out.println("--- Measurements after " + this.iterations + " ops (" + this.interval + " samples) ---");
            System.out.println("Total latency = " + this.totalLatency.getAverage(false) / 1000L + " (+/- " + (long)this.totalLatency.getDP(false) / 1000L + ") us ");
            this.totalLatency.reset();
            System.out.println("Consensus latency = " + this.consensusLatency.getAverage(false) / 1000L + " (+/- " + (long)this.consensusLatency.getDP(false) / 1000L + ") us ");
            this.consensusLatency.reset();
            System.out.println("Pre-consensus latency = " + this.preConsLatency.getAverage(false) / 1000L + " (+/- " + (long)this.preConsLatency.getDP(false) / 1000L + ") us ");
            this.preConsLatency.reset();
            System.out.println("Pos-consensus latency = " + this.posConsLatency.getAverage(false) / 1000L + " (+/- " + (long)this.posConsLatency.getDP(false) / 1000L + ") us ");
            this.posConsLatency.reset();
            System.out.println("Propose latency = " + this.proposeLatency.getAverage(false) / 1000L + " (+/- " + (long)this.proposeLatency.getDP(false) / 1000L + ") us ");
            this.proposeLatency.reset();
            System.out.println("Weak latency = " + this.weakLatency.getAverage(false) / 1000L + " (+/- " + (long)this.weakLatency.getDP(false) / 1000L + ") us ");
            this.weakLatency.reset();
            System.out.println("Strong latency = " + this.strongLatency.getAverage(false) / 1000L + " (+/- " + (long)this.strongLatency.getDP(false) / 1000L + ") us ");
            this.strongLatency.reset();
        }
        return new byte[this.replySize];
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Use: java ...LatencyServer <processId> <measurement interval> <processing hashs> <reply size>");
            System.exit(-1);
        }
        int processId = Integer.parseInt(args[0]);
        int interval = Integer.parseInt(args[1]);
        int hashs = Integer.parseInt(args[2]);
        int replySize = Integer.parseInt(args[3]);
        new LatencyServer(processId, interval, hashs, replySize);
    }

    public byte[] getState() {
        return new byte[0];
    }

    public void setState(byte[] state) {
    }

    @Override
    public ApplicationState getState(int eid, boolean sendState) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int setState(ApplicationState state) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new StandardStateManager();
        }
        return this.stateManager;
    }
}

