/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.listvalue;

import bftsmart.demo.listvalue.BFTMapList;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.defaultservices.DefaultRecoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BFTListImpl
extends DefaultRecoverable {
    BFTMapList tableList = new BFTMapList();
    ServiceReplica replica = null;
    ReplicaContext replicaCtx;

    public BFTListImpl(int id) {
        this.replica = new ServiceReplica(id, this, this);
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaCtx) {
        this.replicaCtx = replicaCtx;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Use: java BFTMapImpl <processId>");
            System.exit(-1);
        }
        new BFTListImpl(Integer.parseInt(args[0]));
    }

    @Override
    public byte[] getSnapshot() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this.tableList);
            out.flush();
            bos.flush();
            out.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException ex) {
            Logger.getLogger(BFTListImpl.class.getName()).log(Level.SEVERE, null, ex);
            return new byte[0];
        }
    }

    @Override
    public void installSnapshot(byte[] state) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(state);
            ObjectInputStream in = new ObjectInputStream(bis);
            this.tableList = (BFTMapList)in.readObject();
            in.close();
            bis.close();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BFTListImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(BFTListImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public byte[][] appExecuteBatch(byte[][] commands, MessageContext[] msgCtxs) {
        byte[][] replies = new byte[commands.length][];
        int i = 0;
        while (i < commands.length) {
            byte[] command = commands[i];
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(command);
                ByteArrayOutputStream out = null;
                byte[] reply = null;
                ArrayList<String> list = null;
                int cmd = new DataInputStream(in).readInt();
                switch (cmd) {
                    case 4: {
                        String listName = new DataInputStream(in).readUTF();
                        String value = new DataInputStream(in).readUTF();
                        out = new ByteArrayOutputStream();
                        boolean added = this.tableList.addData(listName, value);
                        if (added) {
                            System.out.println("added " + listName + " with value " + value);
                        }
                        DataOutputStream dout = new DataOutputStream(out);
                        dout.writeBoolean(added);
                        dout.close();
                        out.close();
                        reply = out.toByteArray();
                        System.out.println("array size: " + reply.length);
                        break;
                    }
                    case 7: {
                        String listName = new DataInputStream(in).readUTF();
                        int index = new DataInputStream(in).readInt();
                        System.out.println("Index received: " + index);
                        String value = this.tableList.removeEntry(listName, index);
                        System.out.println("Value removed is : " + value);
                        out = new ByteArrayOutputStream();
                        new DataOutputStream(out).writeUTF(value);
                        reply = out.toByteArray();
                        out.close();
                        break;
                    }
                    case 1: {
                        String listName = new DataInputStream(in).readUTF();
                        ObjectInputStream objIn = new ObjectInputStream(in);
                        try {
                            boolean hasList = objIn.readBoolean();
                            list = hasList ? (ArrayList<String>)objIn.readObject() : new ArrayList<String>();
                        }
                        catch (ClassNotFoundException ex) {
                            Logger.getLogger(BFTListImpl.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        List<String> listCreated = this.tableList.addList(listName, list);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ObjectOutputStream objOut = new ObjectOutputStream(bos);
                        objOut.writeObject(listCreated);
                        objOut.close();
                        in.close();
                        reply = bos.toByteArray();
                        break;
                    }
                    case 2: {
                        String listName = new DataInputStream(in).readUTF();
                        list = this.tableList.removeList(listName);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ObjectOutputStream objOut = new ObjectOutputStream(bos);
                        objOut.writeObject(list);
                        objOut.close();
                        objOut.close();
                        reply = bos.toByteArray();
                        break;
                    }
                    case 3: {
                        int size1 = this.tableList.getSizeofList();
                        System.out.println("Size " + size1);
                        out = new ByteArrayOutputStream();
                        new DataOutputStream(out).writeInt(size1);
                        reply = out.toByteArray();
                        out.close();
                        break;
                    }
                    case 5: {
                        String listName = new DataInputStream(in).readUTF();
                        System.out.println("tablename: " + listName);
                        int index = new DataInputStream(in).readInt();
                        System.out.println("index received: " + index);
                        String value = this.tableList.getEntry(listName, index);
                        System.out.println("The value to be get is: " + value);
                        out = new ByteArrayOutputStream();
                        new DataOutputStream(out).writeUTF(value);
                        reply = out.toByteArray();
                        out.close();
                        break;
                    }
                    case 6: {
                        String tableName2 = new DataInputStream(in).readUTF();
                        int size = this.tableList.getSize(tableName2);
                        out = new ByteArrayOutputStream();
                        new DataOutputStream(out).writeInt(size);
                        reply = out.toByteArray();
                        out.close();
                        break;
                    }
                    case 8: {
                        String listName = new DataInputStream(in).readUTF();
                        int index = new DataInputStream(in).readInt();
                        System.out.println("Table Key received: " + index);
                        String value = this.tableList.getEntry(listName, index);
                        boolean entryExists = value != null;
                        out = new ByteArrayOutputStream();
                        new DataOutputStream(out).writeBoolean(entryExists);
                        reply = out.toByteArray();
                        out.close();
                        break;
                    }
                    case 10: {
                        String listName = new DataInputStream(in).readUTF();
                        System.out.println("Table of Table Key received: " + listName);
                        list = this.tableList.getName(listName);
                        boolean tableExists = list != null;
                        System.out.println("Table exists: " + tableExists);
                        out = new ByteArrayOutputStream();
                        new DataOutputStream(out).writeBoolean(tableExists);
                        reply = out.toByteArray();
                        out.close();
                    }
                }
                replies[i] = reply;
            }
            catch (IOException ex) {
                Logger.getLogger(BFTListImpl.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            ++i;
        }
        return replies;
    }

    @Override
    public byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(command);
            ByteArrayOutputStream out = null;
            byte[] reply = null;
            int cmd = new DataInputStream(in).readInt();
            switch (cmd) {
                case 3: {
                    int size1 = this.tableList.getSizeofList();
                    System.out.println("Size " + size1);
                    out = new ByteArrayOutputStream();
                    new DataOutputStream(out).writeInt(size1);
                    reply = out.toByteArray();
                    break;
                }
                case 5: {
                    String tableName = new DataInputStream(in).readUTF();
                    System.out.println("tablename: " + tableName);
                    int index = new DataInputStream(in).readInt();
                    System.out.println("Key received: " + index);
                    String value = this.tableList.getEntry(tableName, index);
                    System.out.println("The value to be get is: " + value);
                    out = new ByteArrayOutputStream();
                    new DataOutputStream(out).writeBytes(value);
                    reply = out.toByteArray();
                    break;
                }
                case 6: {
                    String tableName2 = new DataInputStream(in).readUTF();
                    int size = this.tableList.getSize(tableName2);
                    System.out.println("Size " + size);
                    out = new ByteArrayOutputStream();
                    new DataOutputStream(out).writeInt(size);
                    reply = out.toByteArray();
                    break;
                }
                case 8: {
                    String tableName = new DataInputStream(in).readUTF();
                    int index = new DataInputStream(in).readInt();
                    System.out.println("Table Key received: " + index);
                    String value = this.tableList.getEntry(tableName, index);
                    boolean entryExists = value != null;
                    out = new ByteArrayOutputStream();
                    new DataOutputStream(out).writeBoolean(entryExists);
                    reply = out.toByteArray();
                    break;
                }
                case 10: {
                    String tableName = new DataInputStream(in).readUTF();
                    System.out.println("Table of Table Key received: " + tableName);
                    List<String> list = this.tableList.getName(tableName);
                    boolean tableExists = list != null;
                    System.out.println("Table exists: " + tableExists);
                    out = new ByteArrayOutputStream();
                    new DataOutputStream(out).writeBoolean(tableExists);
                    reply = out.toByteArray();
                }
            }
            return reply;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTListImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

