/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.listvalue;

import bftsmart.tom.ServiceProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BFTList
implements Map<String, List<String>> {
    ServiceProxy KVProxy = null;
    private boolean useReadOnly;
    ByteArrayOutputStream out = null;

    BFTList(int id, boolean useReadOnly) {
        this.KVProxy = new ServiceProxy(id, "config");
        this.useReadOnly = useReadOnly;
    }

    public List<String> get(String tableName) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(5);
            new DataOutputStream(this.out).writeUTF(tableName);
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            ObjectInputStream in = new ObjectInputStream(bis);
            List table = (List)in.readObject();
            in.close();
            return table;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getEntry(String tableName, int index) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(5);
            new DataOutputStream(this.out).writeUTF(tableName);
            new DataOutputStream(this.out).writeInt(index);
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            ObjectInputStream in = new ObjectInputStream(bis);
            String value = in.readUTF();
            in.close();
            return value;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public List<String> put(String listName, List<String> value) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(1);
            new DataOutputStream(this.out).writeUTF(listName);
            ObjectOutputStream out1 = new ObjectOutputStream(this.out);
            if (value != null) {
                out1.writeBoolean(true);
                out1.writeObject(value);
            } else {
                out1.writeBoolean(false);
            }
            out1.close();
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            ObjectInputStream in = new ObjectInputStream(bis);
            List list = (List)in.readObject();
            in.close();
            return list;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public boolean putEntry(String listName, String value) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(4);
            new DataOutputStream(this.out).writeUTF(listName);
            new DataOutputStream(this.out).writeUTF(value);
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            System.out.println("blabla1");
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            System.out.println("blabla2");
            DataInputStream in = new DataInputStream(bis);
            System.out.println("blabla3");
            boolean added = in.readBoolean();
            System.out.println("blabla4");
            in.close();
            bis.close();
            return added;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public List<String> remove(Object key) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(2);
            new DataOutputStream(this.out).writeUTF((String)key);
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            ObjectInputStream in = new ObjectInputStream(bis);
            List list = (List)in.readObject();
            in.close();
            return list;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String removeEntry(String tableName, int index) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(7);
            new DataOutputStream(this.out).writeUTF(tableName);
            new DataOutputStream(this.out).writeInt(index);
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            ObjectInputStream in = new ObjectInputStream(bis);
            String rem = in.readUTF();
            in.close();
            return rem;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public int size() {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(3);
            byte[] rep = this.useReadOnly ? this.KVProxy.invokeUnordered(this.out.toByteArray()) : this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream in = new ByteArrayInputStream(rep);
            int size = new DataInputStream(in).readInt();
            return size;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public int size1(String tableName) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(6);
            new DataOutputStream(this.out).writeUTF(tableName);
            byte[] rep = this.useReadOnly ? this.KVProxy.invokeUnordered(this.out.toByteArray()) : this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream in = new ByteArrayInputStream(rep);
            int size = new DataInputStream(in).readInt();
            return size;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    public boolean containsKey(String key) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(10);
            new DataOutputStream(this.out).writeUTF(key);
            byte[] rep = this.useReadOnly ? this.KVProxy.invokeUnordered(this.out.toByteArray()) : this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream in = new ByteArrayInputStream(rep);
            boolean res = new DataInputStream(in).readBoolean();
            return res;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean containsKey1(String tableName, String key) {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(8);
            new DataOutputStream(this.out).writeUTF(tableName);
            new DataOutputStream(this.out).writeUTF(key);
            byte[] rep = this.useReadOnly ? this.KVProxy.invokeUnordered(this.out.toByteArray()) : this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream in = new ByteArrayInputStream(rep);
            boolean res = new DataInputStream(in).readBoolean();
            return res;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTList.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<String> get(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

