/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.counter;

import bftsmart.demo.counter.CounterState;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.StandardStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.BatchExecutable;
import bftsmart.tom.server.Executable;
import bftsmart.tom.server.Recoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.ReentrantLock;

public final class CounterServer
implements BatchExecutable,
Recoverable {
    private int counter = 0;
    private int iterations = 0;
    private ReplicaContext replicaContext = null;
    private MessageDigest md;
    private ReentrantLock stateLock = new ReentrantLock();
    private int lastEid = -1;
    private StateManager stateManager;

    public CounterServer(int id) {
        new ServiceReplica(id, this, this);
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
    }

    public CounterServer(int id, boolean join) {
        new ServiceReplica(id, join, (Executable)this, (Recoverable)this);
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.replicaContext = replicaContext;
    }

    @Override
    public byte[][] executeBatch(byte[][] commands, MessageContext[] msgCtxs) {
        this.stateLock.lock();
        byte[][] replies = new byte[commands.length][];
        int i = 0;
        while (i < commands.length) {
            replies[i] = this.execute(commands[i], msgCtxs[i]);
            ++i;
        }
        this.stateLock.unlock();
        return replies;
    }

    @Override
    public byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        return this.execute(command, msgCtx);
    }

    public byte[] execute(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        try {
            int increment = new DataInputStream(new ByteArrayInputStream(command)).readInt();
            this.counter += increment;
            this.lastEid = msgCtx.getConsensusId();
            if (msgCtx.getConsensusId() == -1) {
                System.out.println("(" + this.iterations + ") Counter incremented: " + this.counter);
            } else {
                System.out.println("(" + this.iterations + " / " + msgCtx.getConsensusId() + ") Counter incremented: " + this.counter);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(4);
            new DataOutputStream(out).writeInt(this.counter);
            return out.toByteArray();
        }
        catch (IOException ex) {
            System.err.println("Invalid request received!");
            return new byte[0];
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Use: java CounterServer <processId> <join option (optional)>");
            System.exit(-1);
        }
        if (args.length > 1) {
            new CounterServer(Integer.parseInt(args[0]), Boolean.valueOf(args[1]));
        } else {
            new CounterServer(Integer.parseInt(args[0]));
        }
    }

    @Override
    public ApplicationState getState(int eid, boolean sendState) {
        this.stateLock.lock();
        if (eid == -1 || eid > this.lastEid) {
            return new CounterState();
        }
        byte[] b = new byte[4];
        byte[] d = null;
        int i = 0;
        while (i < 4) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(this.counter >>> offset & 0xFF);
            ++i;
        }
        this.stateLock.unlock();
        d = this.md.digest(b);
        return new CounterState(this.lastEid, (byte[])(sendState ? b : null), d);
    }

    @Override
    public int setState(ApplicationState state) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (state.getSerializedState()[i] & 0xFF) << shift;
            ++i;
        }
        this.stateLock.lock();
        this.counter = value;
        this.stateLock.unlock();
        this.lastEid = state.getLastEid();
        return state.getLastEid();
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new StandardStateManager();
        }
        return this.stateManager;
    }
}

