/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.counter;

import bftsmart.tom.ServiceProxy;
import bftsmart.tom.util.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class CounterClient {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: java ...CounterClient <process id> <increment> [<number of operations>]");
            System.out.println("       if <increment> equals 0 the request will be read-only");
            System.out.println("       default <number of operations> equals 1000");
            System.exit(-1);
        }
        ServiceProxy counterProxy = new ServiceProxy(Integer.parseInt(args[0]));
        int result = 0;
        try {
            try {
                int inc = Integer.parseInt(args[1]);
                int numberOfOps = args.length > 2 ? Integer.parseInt(args[2]) : 1000;
                boolean wait = false;
                if (args.length > 2 && args[2].equals("wait") || args.length > 3 && args[3].equals("wait")) {
                    wait = true;
                }
                Logger.debug = false;
                BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
                int i = 0;
                while (i < numberOfOps) {
                    if (wait) {
                        System.out.println("Iteration " + i);
                        System.out.println("Press Enter for next iteration, type 'exit' to exit or type 'go' to run all remaining iterations");
                        String lido = inReader.readLine();
                        if (lido.equals("exit")) break;
                        if (lido.equals("go")) {
                            wait = false;
                        }
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream(4);
                    new DataOutputStream(out).writeInt(inc);
                    System.out.println("Counter sending: " + i);
                    byte[] reply = inc == 0 ? counterProxy.invokeUnordered(out.toByteArray()) : counterProxy.invokeOrdered(out.toByteArray());
                    if (reply == null) {
                        result = 1;
                        break;
                    }
                    int newValue = new DataInputStream(new ByteArrayInputStream(reply)).readInt();
                    System.out.println("Counter value: " + newValue);
                    result = 0;
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = 1;
                counterProxy.close();
                System.exit(result);
            }
        }
        finally {
            counterProxy.close();
            System.exit(result);
        }
    }
}

