/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.bftmap;

import bftsmart.demo.bftmap.BFTMap;
import bftsmart.demo.bftmap.BFTMapClientCloudFIT;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

class KVClientInstance
extends Thread {
    private int inc;
    private int id;
    private boolean run;
    private Random rand;

    public KVClientInstance(int id) {
        this.id = id;
        this.inc = 0;
        this.run = true;
        this.rand = new Random(id);
    }

    @Override
    public void run() {
        BFTMap bftMap = new BFTMap(this.id);
        String tableName = "table-" + this.id;
        try {
            this.createTable(bftMap, tableName);
        }
        catch (Exception e1) {
            System.out.println("Problems: Inserting a new value into the table(" + tableName + "): " + e1.getLocalizedMessage());
            System.exit(1);
        }
        while (this.run) {
            try {
                boolean result = this.insertValue(bftMap, tableName);
                if (result) continue;
                System.out.println("Problems: Inserting a new value into the table(" + tableName + ")");
                System.exit(1);
            }
            catch (InterruptedException e) {
                System.out.println("Client id[" + this.id + "]: it was interrupted");
                this.run = false;
            }
            catch (Exception e) {
                bftMap = new BFTMap(this.id);
                try {
                    this.createTable(bftMap, tableName);
                }
                catch (Exception e1) {
                    System.out.println("Client id[" + this.id + "]: problems");
                }
            }
        }
        BFTMapClientCloudFIT.logger.info("Client id[" + this.id + "] operations: " + this.inc);
    }

    public void stopRun() {
        this.run = false;
    }

    private boolean createTable(BFTMap bftMap, String nameTable) throws Exception {
        boolean tableExists = bftMap.containsKey(nameTable);
        if (!tableExists) {
            bftMap.put(nameTable, (Map<String, byte[]>)new TreeMap<String, byte[]>());
        }
        return tableExists;
    }

    private boolean insertValue(BFTMap bftMap, String nameTable) throws Exception {
        String value;
        byte[] valueBytes;
        String key = "Key" + this.rand.nextInt();
        byte[] resultBytes = bftMap.putEntry(nameTable, key, valueBytes = (value = Integer.toString(new Random().nextInt())).getBytes());
        if (resultBytes == null) {
            throw new Exception();
        }
        ++this.inc;
        return true;
    }
}

