/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.bftmap;

import bftsmart.demo.bftmap.BFTMap;
import java.io.Console;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class BFTMapInteractiveClient {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: java BFTMapInteractiveClient <process id>");
            System.exit(-1);
        }
        BFTMap bftMap = new BFTMap(Integer.parseInt(args[0]));
        Console console = System.console();
        Scanner sc = new Scanner(System.in);
        while (true) {
            System.out.println("select a command : 1. CREATE A NEW TABLE OF TABLES");
            System.out.println("select a command : 2. REMOVE AN EXISTING TABLE");
            System.out.println("select a command : 3. GET THE SIZE OF THE TABLE OF TABLES");
            System.out.println("select a command : 4. PUT VALUES INTO A TABLE");
            System.out.println("select a command : 5. GET VALUES FROM A TABLE");
            System.out.println("select a command : 6. GET THE SIZE OF A TABLE");
            System.out.println("select a command : 7. REMOVE AN EXISTING TABLE");
            System.out.println("select a command : 11. EXIT");
            int cmd = sc.nextInt();
            switch (cmd) {
                case 1: {
                    String tableName;
                    boolean tableExists = false;
                    do {
                        if (tableExists = bftMap.containsKey(tableName = console.readLine("Enter the HashMap name: ", new Object[0]))) continue;
                        bftMap.put(tableName, (Map<String, byte[]>)new TreeMap<String, byte[]>());
                    } while (tableExists);
                    break;
                }
                case 3: {
                    System.out.println("Computing the size of the table");
                    int size = bftMap.size();
                    System.out.println("The size of the table of tables is: " + size);
                    break;
                }
                case 2: {
                    boolean tableExists = false;
                    String tableName = null;
                    System.out.println("Removing table");
                    tableName = console.readLine("Enter the valid table name you want to remove: ", new Object[0]);
                    tableExists = bftMap.containsKey(tableName);
                    if (tableExists) {
                        bftMap.remove(tableName);
                        System.out.println("Table removed");
                        break;
                    }
                    System.out.println("Table not found");
                    break;
                }
                case 4: {
                    byte[] resultBytes;
                    System.out.println("Execute put function");
                    boolean tableExists = false;
                    String tableName = null;
                    int size = -1;
                    tableName = console.readLine("Enter the valid table name in which you want to insert data: ", new Object[0]);
                    String key = console.readLine("Enter a numeric key for the new record in the range 0 to 9999: ", new Object[0]);
                    String value = console.readLine("Enter the value for the new record: ", new Object[0]);
                    tableExists = bftMap.containsKey(tableName);
                    if (tableExists) {
                        while (key.length() < 4) {
                            key = "0" + key;
                        }
                        byte[] byteArray = value.getBytes();
                        resultBytes = bftMap.putEntry(tableName, key, byteArray);
                        break;
                    }
                    System.out.println("Table not found");
                    break;
                }
                case 5: {
                    byte[] resultBytes;
                    System.out.println("Execute get function");
                    boolean tableExists = false;
                    boolean keyExists = false;
                    String tableName = null;
                    String key = null;
                    tableName = console.readLine("Enter the valid table name from which you want to get the values: ", new Object[0]);
                    tableExists = bftMap.containsKey(tableName);
                    if (tableExists) {
                        key = console.readLine("Enter the key: ", new Object[0]);
                        while (key.length() < 4) {
                            key = "0" + key;
                        }
                        keyExists = bftMap.containsKey1(tableName, key);
                        if (keyExists) {
                            resultBytes = bftMap.getEntry(tableName, key);
                            System.out.println("The value received from GET is: " + new String(resultBytes));
                            break;
                        }
                        System.out.println("Key not found");
                        break;
                    }
                    System.out.println("Table not found");
                    break;
                }
                case 6: {
                    System.out.println("Execute get function");
                    boolean tableExists = false;
                    String tableName = null;
                    int size = -1;
                    tableName = console.readLine("Enter the valid table whose size you want to detemine: ", new Object[0]);
                    tableExists = bftMap.containsKey(tableName);
                    if (tableExists) {
                        size = bftMap.size1(tableName);
                        System.out.println("The size is: " + size);
                        break;
                    }
                    System.out.println("Table not found");
                    break;
                }
                case 7: {
                    System.out.println("Execute get function");
                    boolean tableExists = false;
                    boolean keyExists = false;
                    String tableName = null;
                    String key = null;
                    tableName = console.readLine("Enter the table name from which you want to remove: ", new Object[0]);
                    tableExists = bftMap.containsKey(tableName);
                    if (tableExists) {
                        key = console.readLine("Enter the valid key: ", new Object[0]);
                        keyExists = bftMap.containsKey1(tableName, key);
                        if (keyExists) {
                            byte[] result2 = bftMap.removeEntry(tableName, key);
                            System.out.println("The previous value was : " + new String(result2));
                            break;
                        }
                        System.out.println("Key not found");
                        break;
                    }
                    System.out.println("Table not found");
                    break;
                }
                case 11: {
                    System.exit(-1);
                }
            }
        }
    }
}

