/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.server;

import bftsmart.communication.SystemMessage;
import bftsmart.communication.server.ServersCommunicationLayer;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.Storage;
import java.util.concurrent.LinkedBlockingQueue;

public class Test {
    public static void main(String[] args) throws Exception {
        ServerViewManager manager = new ServerViewManager(Integer.parseInt(args[0]));
        LinkedBlockingQueue<SystemMessage> inQueue = new LinkedBlockingQueue<SystemMessage>();
        ServersCommunicationLayer scl = new ServersCommunicationLayer(manager, inQueue, null);
        int id = manager.getStaticConf().getProcessId();
        int n = manager.getCurrentViewN();
        int[] targets = new int[n - 1];
        System.out.println("n = " + n);
        int i = 1;
        while (i < n) {
            targets[i - 1] = i;
            ++i;
        }
        int iteractions = Integer.parseInt(args[1]);
        int warmup = iteractions / 2;
        int test = iteractions / 2;
        int i2 = 0;
        while (i2 < warmup) {
            String msg = "m" + i2;
            if (id == 0) {
                long time = System.nanoTime();
                scl.send(targets, new TOMMessage(id, 0, i2, msg.getBytes(), 0), true);
                int rec = 0;
                while (rec < n - 1) {
                    inQueue.take();
                    ++rec;
                }
                System.out.println("Roundtrip " + (double)(System.nanoTime() - time) / 1000.0 + " us");
            } else {
                TOMMessage m = (TOMMessage)inQueue.take();
                scl.send(new int[]{m.getSender()}, new TOMMessage(id, 0, i2, m.getContent(), 0), true);
            }
            ++i2;
        }
        System.out.println("Beginning the real test with " + test + " roundtrips");
        Storage st = new Storage(test);
        int i3 = 0;
        while (i3 < test) {
            String msg = "m" + i3;
            if (id == 0) {
                long time = System.nanoTime();
                scl.send(targets, new TOMMessage(id, 0, i3, msg.getBytes(), 0), true);
                int rec = 0;
                while (rec < n - 1) {
                    inQueue.take();
                    ++rec;
                }
                st.store(System.nanoTime() - time);
            } else {
                TOMMessage m = (TOMMessage)inQueue.take();
                scl.send(new int[]{m.getSender()}, new TOMMessage(id, 0, i3, m.getContent(), 0), true);
            }
            ++i3;
        }
        System.out.println("Average time for " + test + " executions (-10%) = " + st.getAverage(true) / 1000L + " us ");
        System.out.println("Standard desviation for " + test + " executions (-10%) = " + st.getDP(true) / 1000.0 + " us ");
        System.out.println("Maximum time for " + test + " executions (-10%) = " + st.getMax(true) / 1000L + " us ");
        System.out.println("Average time for " + test + " executions (all samples) = " + st.getAverage(false) / 1000L + " us ");
        System.out.println("Standard desviation for " + test + " executions (all samples) = " + st.getDP(false) / 1000.0 + " us ");
        System.out.println("Maximum time for " + test + " executions (all samples) = " + st.getMax(false) / 1000L + " us ");
    }
}

