/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.server;

import bftsmart.communication.SystemMessage;
import bftsmart.communication.server.ServerConnection;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.ServiceReplica;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class ServersCommunicationLayer
extends Thread {
    private ServerViewManager manager;
    private LinkedBlockingQueue<SystemMessage> inQueue;
    private Hashtable<Integer, ServerConnection> connections = new Hashtable();
    private ServerSocket serverSocket;
    private int me;
    private boolean doWork = true;
    private Lock connectionsLock = new ReentrantLock();
    private ReentrantLock waitViewLock = new ReentrantLock();
    private List<PendingConnection> pendingConn = new LinkedList<PendingConnection>();
    private ServiceReplica replica;
    private SecretKey selfPwd;
    private static final String PASSWORD = "commsyst";

    public ServersCommunicationLayer(ServerViewManager manager, LinkedBlockingQueue<SystemMessage> inQueue, ServiceReplica replica) throws Exception {
        this.manager = manager;
        this.inQueue = inQueue;
        this.me = manager.getStaticConf().getProcessId();
        this.replica = replica;
        if (manager.isInCurrentView()) {
            int[] initialV = manager.getCurrentViewAcceptors();
            int i = 0;
            while (i < initialV.length) {
                if (initialV[i] != this.me) {
                    this.getConnection(initialV[i]);
                }
                ++i;
            }
        }
        this.serverSocket = new ServerSocket(manager.getStaticConf().getServerToServerPort(manager.getStaticConf().getProcessId()));
        SecretKeyFactory fac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        PBEKeySpec spec = new PBEKeySpec(PASSWORD.toCharArray());
        this.selfPwd = fac.generateSecret(spec);
        this.serverSocket.setSoTimeout(10000);
        this.serverSocket.setReuseAddress(true);
        this.start();
    }

    public SecretKey getSecretKey(int id) {
        if (id == this.manager.getStaticConf().getProcessId()) {
            return this.selfPwd;
        }
        return this.connections.get(id).getSecretKey();
    }

    public void updateConnections() {
        this.connectionsLock.lock();
        if (this.manager.isInCurrentView()) {
            Iterator<Integer> it = this.connections.keySet().iterator();
            LinkedList<Integer> toRemove = new LinkedList<Integer>();
            while (it.hasNext()) {
                int rm = it.next();
                if (this.manager.isCurrentViewMember(rm)) continue;
                toRemove.add(rm);
            }
            int i = 0;
            while (i < toRemove.size()) {
                this.connections.remove(toRemove.get(i)).shutdown();
                ++i;
            }
            int[] newV = this.manager.getCurrentViewAcceptors();
            int i2 = 0;
            while (i2 < newV.length) {
                if (newV[i2] != this.me) {
                    this.getConnection(newV[i2]);
                }
                ++i2;
            }
        } else {
            Iterator<Integer> it = this.connections.keySet().iterator();
            while (it.hasNext()) {
                this.connections.get(it.next()).shutdown();
            }
        }
        this.connectionsLock.unlock();
    }

    private ServerConnection getConnection(int remoteId) {
        this.connectionsLock.lock();
        ServerConnection ret = this.connections.get(remoteId);
        if (ret == null) {
            ret = new ServerConnection(this.manager, null, remoteId, this.inQueue, this.replica);
            this.connections.put(remoteId, ret);
        }
        this.connectionsLock.unlock();
        return ret;
    }

    public final void send(int[] targets, SystemMessage sm, boolean useMAC) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
        try {
            new ObjectOutputStream(bOut).writeObject(sm);
        }
        catch (IOException ex) {
            Logger.getLogger(ServerConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        byte[] data = bOut.toByteArray();
        int[] nArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            try {
                if (i == this.me) {
                    sm.authenticated = true;
                    this.inQueue.put(sm);
                } else {
                    this.getConnection(i).send(data, useMAC);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    public void shutdown() {
        this.doWork = false;
        int[] activeServers = this.manager.getCurrentViewAcceptors();
        int i = 0;
        while (i < activeServers.length) {
            if (this.me != activeServers[i]) {
                this.getConnection(activeServers[i]).shutdown();
            }
            ++i;
        }
    }

    public void joinViewReceived() {
        this.waitViewLock.lock();
        int i = 0;
        while (i < this.pendingConn.size()) {
            PendingConnection pc = this.pendingConn.get(i);
            try {
                this.establishConnection(pc.s, pc.remoteId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.pendingConn.clear();
        this.waitViewLock.unlock();
    }

    @Override
    public void run() {
        while (this.doWork) {
            try {
                Socket newSocket = this.serverSocket.accept();
                ServersCommunicationLayer.setSocketOptions(newSocket);
                int remoteId = new DataInputStream(newSocket.getInputStream()).readInt();
                if (!this.manager.isInCurrentView() && this.manager.getStaticConf().getTTPId() != remoteId) {
                    this.waitViewLock.lock();
                    this.pendingConn.add(new PendingConnection(newSocket, remoteId));
                    this.waitViewLock.unlock();
                    continue;
                }
                this.establishConnection(newSocket, remoteId);
            }
            catch (SocketTimeoutException newSocket) {
            }
            catch (IOException ex) {
                Logger.getLogger(ServersCommunicationLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ServersCommunicationLayer.class.getName()).log(Level.SEVERE, null, ex);
        }
        Logger.getLogger(ServersCommunicationLayer.class.getName()).log(Level.INFO, "Server communication layer stoped.");
    }

    private void establishConnection(Socket newSocket, int remoteId) throws IOException {
        if (this.manager.getStaticConf().getTTPId() == remoteId || this.manager.isCurrentViewMember(remoteId)) {
            this.connectionsLock.lock();
            if (this.connections.get(remoteId) == null) {
                this.connections.put(remoteId, new ServerConnection(this.manager, newSocket, remoteId, this.inQueue, this.replica));
            } else {
                this.connections.get(remoteId).reconnect(newSocket);
            }
            this.connectionsLock.unlock();
        } else {
            newSocket.close();
        }
    }

    public static void setSocketOptions(Socket socket) {
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            Logger.getLogger(ServersCommunicationLayer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String toString() {
        String str = "inQueue=" + this.inQueue.toString();
        int[] activeServers = this.manager.getCurrentViewAcceptors();
        int i = 0;
        while (i < activeServers.length) {
            if (this.me != activeServers[i]) {
                str = String.valueOf(str) + ", connections[" + activeServers[i] + "]: outQueue=" + this.getConnection((int)activeServers[i]).outQueue;
            }
            ++i;
        }
        return str;
    }

    public class PendingConnection {
        public Socket s;
        public int remoteId;

        public PendingConnection(Socket s, int remoteId) {
            this.s = s;
            this.remoteId = remoteId;
        }
    }
}

