/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.tom.core.messages.TOMMessage;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

@ChannelPipelineCoverage(value="all")
public class NettyTOMMessageEncoder
extends SimpleChannelHandler {
    private boolean isClient;
    private Map sessionTable;
    private int macLength;
    private int signatureLength;
    private ReentrantReadWriteLock rl;
    private boolean useMAC;

    public NettyTOMMessageEncoder(boolean isClient, Map sessionTable, int macLength, ReentrantReadWriteLock rl, int signatureLength, boolean useMAC) {
        this.isClient = isClient;
        this.sessionTable = sessionTable;
        this.macLength = macLength;
        this.rl = rl;
        this.signatureLength = signatureLength;
        this.useMAC = useMAC;
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        TOMMessage sm = (TOMMessage)e.getMessage();
        byte[] macData = null;
        byte[] signatureData = null;
        byte[] msgData = sm.serializedMessage;
        if (sm.signed && (signatureData = sm.serializedMessageSignature).length != this.signatureLength) {
            System.out.println("WARNING: message signature has size " + signatureData.length + " and should have " + this.signatureLength);
        }
        if (this.useMAC && (macData = this.produceMAC(sm.destination, msgData, sm.getSender())) == null) {
            System.out.println("uses MAC and the MAC returned is null. Won't write to channel");
            return;
        }
        int dataLength = 1 + msgData.length + (macData == null ? 0 : macData.length) + (signatureData == null ? 0 : signatureData.length);
        ChannelBuffer buf = ChannelBuffers.buffer((int)(4 + dataLength));
        buf.writeInt(dataLength);
        buf.writeByte(sm.signed ? (byte)1 : 0);
        buf.writeBytes(msgData);
        if (this.useMAC) {
            buf.writeBytes(macData);
        }
        if (signatureData != null) {
            buf.writeBytes(signatureData);
        }
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)buf);
    }

    byte[] produceMAC(int id, byte[] data, int me) {
        NettyClientServerSession session = (NettyClientServerSession)this.sessionTable.get(id);
        if (session == null) {
            System.out.println("NettyTOMMessageEncoder.produceMAC(). session for client " + id + " is null");
            return null;
        }
        Mac macSend = session.getMacSend();
        return macSend.doFinal(data);
    }
}

