/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.reconfiguration.ViewManager;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

@ChannelPipelineCoverage(value="one")
public class NettyTOMMessageDecoder
extends FrameDecoder {
    private boolean isClient;
    private Map sessionTable;
    private SecretKey authKey;
    private int macSize;
    private int signatureSize;
    private ViewManager manager;
    private boolean firstTime;
    private ReentrantReadWriteLock rl;
    private boolean useMAC;

    public NettyTOMMessageDecoder(boolean isClient, Map sessionTable, SecretKey authKey, int macLength, ViewManager manager, ReentrantReadWriteLock rl, int signatureLength, boolean useMAC) {
        this.isClient = isClient;
        this.sessionTable = sessionTable;
        this.authKey = authKey;
        this.macSize = macLength;
        this.manager = manager;
        this.firstTime = true;
        this.rl = rl;
        this.signatureSize = signatureLength;
        this.useMAC = useMAC;
        Logger.println("new NettyTOMMessageDecoder!!, isClient=" + isClient);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) {
        TOMMessage sm;
        block16: {
            byte[] digest;
            byte[] data;
            block17: {
                block15: {
                    if (buffer.readableBytes() < 4) {
                        return null;
                    }
                    int dataLength = buffer.getInt(buffer.readerIndex());
                    if (buffer.readableBytes() < dataLength + 4) {
                        return null;
                    }
                    buffer.skipBytes(4);
                    int totalLength = dataLength - 1;
                    byte signed = buffer.readByte();
                    int authLength = 0;
                    if (signed == 1) {
                        authLength += this.signatureSize;
                    }
                    if (this.useMAC) {
                        authLength += this.macSize;
                    }
                    data = new byte[totalLength - authLength];
                    buffer.readBytes(data);
                    digest = null;
                    if (this.useMAC) {
                        digest = new byte[this.macSize];
                        buffer.readBytes(digest);
                    }
                    byte[] signature = null;
                    if (signed == 1) {
                        signature = new byte[this.signatureSize];
                        buffer.readBytes(signature);
                    }
                    DataInputStream dis = null;
                    sm = null;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        dis = new DataInputStream(bais);
                        sm = new TOMMessage();
                        sm.rExternal(dis);
                        sm.serializedMessage = data;
                        if (signed == 1) {
                            sm.serializedMessageSignature = signature;
                            sm.signed = true;
                        }
                        if (this.useMAC) {
                            sm.serializedMessageMAC = digest;
                        }
                        if (!this.isClient) break block15;
                        if (this.useMAC && !this.verifyMAC(sm.getSender(), data, digest)) {
                            System.out.println("MAC error: message discarded");
                            return null;
                        }
                        break block16;
                    }
                    catch (Exception ex) {
                        Logger.println("Impossible to decode message: " + ex.getMessage());
                        ex.printStackTrace();
                        return null;
                    }
                }
                this.rl.readLock().lock();
                if (!this.sessionTable.containsKey(sm.getSender())) break block17;
                this.rl.readLock().unlock();
                if (this.useMAC && !this.verifyMAC(sm.getSender(), data, digest)) {
                    Logger.println("MAC error: message discarded");
                    return null;
                }
                break block16;
            }
            Logger.println("Creating MAC/public key stuff, first message from client" + sm.getSender());
            Logger.println("sessionTable size=" + this.sessionTable.size());
            this.rl.readLock().unlock();
            Mac macSend = Mac.getInstance(this.manager.getStaticConf().getHmacAlgorithm());
            macSend.init(this.authKey);
            Mac macReceive = Mac.getInstance(this.manager.getStaticConf().getHmacAlgorithm());
            macReceive.init(this.authKey);
            NettyClientServerSession cs = new NettyClientServerSession(channel, macSend, macReceive, sm.getSender(), this.manager.getStaticConf().getRSAPublicKey(), new ReentrantLock());
            this.rl.writeLock().lock();
            System.out.println("adding " + sm.getSender() + " to sessionTable. Null " + (cs == null));
            this.sessionTable.put(sm.getSender(), cs);
            Logger.println("#active clients " + this.sessionTable.size());
            this.rl.writeLock().unlock();
            if (!this.useMAC || this.verifyMAC(sm.getSender(), data, digest)) break block16;
            Logger.println("MAC error: message discarded");
            return null;
        }
        return sm;
    }

    boolean verifyMAC(int id, byte[] data, byte[] digest) {
        this.rl.readLock().lock();
        Mac macReceive = ((NettyClientServerSession)this.sessionTable.get(id)).getMacReceive();
        this.rl.readLock().unlock();
        boolean result = Arrays.equals(macReceive.doFinal(data), digest);
        return result;
    }
}

