/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.CommunicationSystemServerSide;
import bftsmart.communication.client.RequestReceiver;
import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.communication.client.netty.NettyServerPipelineFactory;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

@ChannelPipelineCoverage(value="all")
public class NettyClientServerCommunicationSystemServerSide
extends SimpleChannelHandler
implements CommunicationSystemServerSide {
    private static final String PASSWORD = "newcs";
    private RequestReceiver requestReceiver;
    private HashMap sessionTable;
    private ReentrantReadWriteLock rl;
    private SecretKey authKey;
    private ServerViewManager manager;
    private ReentrantLock sendLock = new ReentrantLock();

    public NettyClientServerCommunicationSystemServerSide(ServerViewManager manager) {
        try {
            SecretKeyFactory fac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            PBEKeySpec spec = new PBEKeySpec(PASSWORD.toCharArray());
            this.authKey = fac.generateSecret(spec);
            this.manager = manager;
            this.sessionTable = new HashMap();
            this.rl = new ReentrantReadWriteLock();
            ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
            Mac macDummy = Mac.getInstance(manager.getStaticConf().getHmacAlgorithm());
            bootstrap.setOption("tcpNoDelay", (Object)true);
            bootstrap.setOption("keepAlive", (Object)true);
            bootstrap.setOption("child.tcpNoDelay", (Object)true);
            bootstrap.setOption("child.keepAlive", (Object)true);
            bootstrap.setPipelineFactory((ChannelPipelineFactory)new NettyServerPipelineFactory(this, false, this.sessionTable, this.authKey, macDummy.getMacLength(), manager, this.rl, TOMUtil.getSignatureSize(manager), new ReentrantLock()));
            bootstrap.bind((SocketAddress)new InetSocketAddress(manager.getStaticConf().getHost(manager.getStaticConf().getProcessId()), manager.getStaticConf().getPort(manager.getStaticConf().getProcessId())));
            System.out.println("#Bound to port " + manager.getStaticConf().getPort(manager.getStaticConf().getProcessId()));
            System.out.println("#myId " + manager.getStaticConf().getProcessId());
            System.out.println("#n " + manager.getCurrentViewN());
            System.out.println("#f " + manager.getCurrentViewF());
            System.out.println("#requestTimeout= " + manager.getStaticConf().getRequestTimeout());
            System.out.println("#maxBatch= " + manager.getStaticConf().getMaxBatchSize());
            System.out.println("#Using MACs = " + manager.getStaticConf().getUseMACs());
            System.out.println("#Using Signatures = " + manager.getStaticConf().getUseSignatures());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (e.getCause() instanceof ClosedChannelException) {
            System.out.println("Connection with client closed.");
        } else if (e.getCause() instanceof ConnectException) {
            System.out.println("Impossible to connect to client.");
        } else {
            e.getCause().printStackTrace(System.err);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        if (this.requestReceiver == null) {
            System.out.println("RECEIVER NULO!!!!!!!!!!!!");
        } else {
            this.requestReceiver.requestReceived((TOMMessage)e.getMessage());
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Logger.println("Session Created, active clients=" + this.sessionTable.size());
        System.out.println("Session Created, active clients=" + this.sessionTable.size());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.rl.writeLock().lock();
        try {
            Set s = this.sessionTable.entrySet();
            for (Map.Entry m : s) {
                NettyClientServerSession value = (NettyClientServerSession)m.getValue();
                if (!e.getChannel().equals(value.getChannel())) continue;
                int key = (Integer)m.getKey();
                System.out.println("#Removing client channel with ID= " + key);
                this.sessionTable.remove(key);
                System.out.println("#active clients=" + this.sessionTable.size());
                break;
            }
        }
        finally {
            this.rl.writeLock().unlock();
        }
        Logger.println("Session Closed, active clients=" + this.sessionTable.size());
    }

    @Override
    public void setRequestReceiver(RequestReceiver tl) {
        this.requestReceiver = tl;
    }

    @Override
    public void send(int[] targets, TOMMessage sm, boolean serializeClassHeaders) {
        byte[] data;
        block17: {
            FilterOutputStream dos = null;
            data = null;
            try {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    dos = new DataOutputStream(baos);
                    sm.wExternal((DataOutput)((Object)dos));
                    ((DataOutputStream)dos).flush();
                    data = baos.toByteArray();
                    sm.serializedMessage = data;
                }
                catch (IOException ex) {
                    Logger.println("Error enconding message.");
                    try {
                        dos.close();
                    }
                    catch (IOException ex2) {
                        System.out.println("Exception closing DataOutputStream: " + ex2.getMessage());
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    dos.close();
                }
                catch (IOException ex) {
                    System.out.println("Exception closing DataOutputStream: " + ex.getMessage());
                }
                throw throwable;
            }
            try {
                dos.close();
            }
            catch (IOException ex) {
                System.out.println("Exception closing DataOutputStream: " + ex.getMessage());
            }
        }
        sm.signed = false;
        if (sm.signed) {
            byte[] data2 = TOMUtil.signMessage(this.manager.getStaticConf().getRSAPrivateKey(), data);
            sm.serializedMessageSignature = data2;
        }
        int i = 0;
        while (i < targets.length) {
            this.rl.readLock().lock();
            this.sendLock.lock();
            try {
                NettyClientServerSession ncss = (NettyClientServerSession)this.sessionTable.get(targets[i]);
                if (ncss != null) {
                    Channel session = ncss.getChannel();
                    sm.destination = targets[i];
                    session.write((Object)sm);
                }
            }
            finally {
                this.sendLock.unlock();
                this.rl.readLock().unlock();
            }
            ++i;
        }
    }
}

