/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.CommunicationSystemClientSide;
import bftsmart.communication.client.ReplyReceiver;
import bftsmart.communication.client.netty.NettyClientPipelineFactory;
import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.reconfiguration.ClientViewManager;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

@ChannelPipelineCoverage(value="all")
public class NettyClientServerCommunicationSystemClientSide
extends SimpleChannelUpstreamHandler
implements CommunicationSystemClientSide {
    private static final String PASSWORD = "newcs";
    protected ReplyReceiver trr;
    private ClientViewManager manager;
    private Map sessionTable = new HashMap();
    private ReentrantReadWriteLock rl;
    private SecretKey authKey;
    private Signature signatureEngine;
    private int signatureLength;
    private boolean closed = false;

    public NettyClientServerCommunicationSystemClientSide(ClientViewManager manager) {
        try {
            SecretKeyFactory fac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            PBEKeySpec spec = new PBEKeySpec(PASSWORD.toCharArray());
            this.authKey = fac.generateSecret(spec);
            this.manager = manager;
            this.rl = new ReentrantReadWriteLock();
            Mac macDummy = Mac.getInstance(manager.getStaticConf().getHmacAlgorithm());
            this.signatureLength = TOMUtil.getSignatureSize(manager);
            int[] currV = manager.getCurrentViewProcesses();
            int i = 0;
            while (i < currV.length) {
                try {
                    ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
                    bootstrap.setOption("tcpNoDelay", (Object)true);
                    bootstrap.setOption("keepAlive", (Object)true);
                    bootstrap.setOption("connectTimeoutMillis", (Object)10000);
                    bootstrap.setPipelineFactory((ChannelPipelineFactory)new NettyClientPipelineFactory(this, true, this.sessionTable, this.authKey, macDummy.getMacLength(), manager, this.rl, this.signatureLength, new ReentrantLock()));
                    ChannelFuture future = bootstrap.connect(manager.getRemoteAddress(currV[i]));
                    Mac macSend = Mac.getInstance(manager.getStaticConf().getHmacAlgorithm());
                    macSend.init(this.authKey);
                    Mac macReceive = Mac.getInstance(manager.getStaticConf().getHmacAlgorithm());
                    macReceive.init(this.authKey);
                    NettyClientServerSession cs = new NettyClientServerSession(future.getChannel(), macSend, macReceive, currV[i], manager.getStaticConf().getRSAPublicKey(), new ReentrantLock());
                    this.sessionTable.put(currV[i], cs);
                    System.out.println("Connecting to replica " + currV[i] + " at " + manager.getRemoteAddress(currV[i]));
                    future.awaitUninterruptibly();
                    if (!future.isSuccess()) {
                        System.err.println("Impossible to connect to " + currV[i]);
                    }
                }
                catch (NullPointerException ex) {
                    System.err.println("Should fix the problem, and I think it has no other implications :-), but we must make the servers store the view in a different place.");
                }
                catch (InvalidKeyException ex) {
                    ex.printStackTrace(System.err);
                }
                ++i;
            }
        }
        catch (InvalidKeySpecException ex) {
            ex.printStackTrace(System.err);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void updateConnections() {
        int[] currV = this.manager.getCurrentViewProcesses();
        try {
            Mac macDummy = Mac.getInstance(this.manager.getStaticConf().getHmacAlgorithm());
            int i = 0;
            while (i < currV.length) {
                this.rl.readLock().lock();
                if (this.sessionTable.get(currV[i]) == null) {
                    this.rl.readLock().unlock();
                    this.rl.writeLock().lock();
                    try {
                        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
                        bootstrap.setOption("tcpNoDelay", (Object)true);
                        bootstrap.setOption("keepAlive", (Object)true);
                        bootstrap.setOption("connectTimeoutMillis", (Object)10000);
                        bootstrap.setPipelineFactory((ChannelPipelineFactory)new NettyClientPipelineFactory(this, true, this.sessionTable, this.authKey, macDummy.getMacLength(), this.manager, this.rl, this.signatureLength, new ReentrantLock()));
                        ChannelFuture future = bootstrap.connect(this.manager.getRemoteAddress(currV[i]));
                        Mac macSend = Mac.getInstance(this.manager.getStaticConf().getHmacAlgorithm());
                        macSend.init(this.authKey);
                        Mac macReceive = Mac.getInstance(this.manager.getStaticConf().getHmacAlgorithm());
                        macReceive.init(this.authKey);
                        NettyClientServerSession cs = new NettyClientServerSession(future.getChannel(), macSend, macReceive, currV[i], this.manager.getStaticConf().getRSAPublicKey(), new ReentrantLock());
                        this.sessionTable.put(currV[i], cs);
                        System.out.println("Connecting to replica " + currV[i] + " at " + this.manager.getRemoteAddress(currV[i]));
                        future.awaitUninterruptibly();
                    }
                    catch (InvalidKeyException ex) {
                        ex.printStackTrace();
                    }
                    this.rl.writeLock().unlock();
                } else {
                    this.rl.readLock().unlock();
                }
                ++i;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (e.getCause() instanceof ClosedChannelException) {
            System.out.println("Connection with replica closed.");
        } else if (!(e.getCause() instanceof ConnectException)) {
            System.out.println("Replica disconnected.");
            e.getCause().printStackTrace();
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        TOMMessage sm = (TOMMessage)e.getMessage();
        this.trr.replyReceived(sm);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        System.out.println("Channel connected");
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        if (this.closed) {
            System.out.println("Channel closed");
            return;
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.rl.writeLock().lock();
        ArrayList sessions = new ArrayList(this.sessionTable.values());
        for (NettyClientServerSession ncss : sessions) {
            if (ncss.getChannel() != ctx.getChannel()) continue;
            try {
                Mac macDummy = Mac.getInstance(this.manager.getStaticConf().getHmacAlgorithm());
                ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
                bootstrap.setPipelineFactory((ChannelPipelineFactory)new NettyClientPipelineFactory(this, true, this.sessionTable, this.authKey, macDummy.getMacLength(), this.manager, this.rl, TOMUtil.getSignatureSize(this.manager), new ReentrantLock()));
                if (this.manager.getRemoteAddress(ncss.getReplicaId()) != null) {
                    ChannelFuture future = bootstrap.connect(this.manager.getRemoteAddress(ncss.getReplicaId()));
                    Mac macSend = ncss.getMacSend();
                    Mac macReceive = ncss.getMacReceive();
                    NettyClientServerSession cs = new NettyClientServerSession(future.getChannel(), macSend, macReceive, ncss.getReplicaId(), this.manager.getStaticConf().getRSAPublicKey(), new ReentrantLock());
                    this.sessionTable.remove(ncss.getReplicaId());
                    this.sessionTable.put(ncss.getReplicaId(), cs);
                    continue;
                }
                this.sessionTable.remove(ncss.getReplicaId());
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
        }
        this.rl.writeLock().unlock();
    }

    @Override
    public void setReplyReceiver(ReplyReceiver trr) {
        this.trr = trr;
    }

    @Override
    public void send(boolean sign, int[] targets, TOMMessage sm) {
        block18: {
            if (sm.serializedMessage == null) {
                FilterOutputStream dos = null;
                try {
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        dos = new DataOutputStream(baos);
                        sm.wExternal((DataOutput)((Object)dos));
                        ((DataOutputStream)dos).flush();
                        sm.serializedMessage = baos.toByteArray();
                    }
                    catch (IOException ex) {
                        System.out.println("Impossible to serialize message: " + sm);
                        try {
                            dos.close();
                        }
                        catch (IOException iOException) {}
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        dos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    dos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (sign && sm.serializedMessageSignature == null) {
            sm.serializedMessageSignature = this.signMessage(this.manager.getStaticConf().getRSAPrivateKey(), sm.serializedMessage);
        }
        int sent = 0;
        int i = targets.length - 1;
        while (i >= 0) {
            sm.destination = targets[i];
            this.rl.readLock().lock();
            Channel channel = ((NettyClientServerSession)this.sessionTable.get(targets[i])).getChannel();
            this.rl.readLock().unlock();
            if (channel.isConnected()) {
                sm.signed = sign;
                channel.write((Object)sm);
                ++sent;
            } else {
                Logger.println("Channel to " + targets[i] + " is not connected");
            }
            --i;
        }
        if (targets.length > this.manager.getCurrentViewF() && sent < this.manager.getCurrentViewF() + 1) {
            throw new RuntimeException("Impossible to connect to servers!");
        }
        if (targets.length == 1 && sent == 0) {
            throw new RuntimeException("Server not connected");
        }
    }

    @Override
    public void sign(TOMMessage sm) {
        byte[] data;
        block11: {
            FilterOutputStream dos = null;
            data = null;
            try {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    dos = new DataOutputStream(baos);
                    sm.wExternal((DataOutput)((Object)dos));
                    ((DataOutputStream)dos).flush();
                    data = baos.toByteArray();
                    sm.serializedMessage = data;
                }
                catch (IOException baos) {
                    try {
                        dos.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    dos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                dos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        byte[] data2 = this.signMessage(this.manager.getStaticConf().getRSAPrivateKey(), data);
        sm.serializedMessageSignature = data2;
    }

    public byte[] signMessage(PrivateKey key, byte[] message) {
        try {
            if (this.signatureEngine == null) {
                this.signatureEngine = Signature.getInstance("SHA1withRSA");
            }
            byte[] result = null;
            this.signatureEngine.initSign(key);
            this.signatureEngine.update(message);
            result = this.signatureEngine.sign();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.rl.readLock().lock();
        ArrayList sessions = new ArrayList(this.sessionTable.values());
        this.rl.readLock().unlock();
        for (NettyClientServerSession ncss : sessions) {
            ncss.getChannel().close();
        }
    }
}

