/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.netty.NettyClientServerCommunicationSystemClientSide;
import bftsmart.communication.client.netty.NettyTOMMessageDecoder;
import bftsmart.communication.client.netty.NettyTOMMessageEncoder;
import bftsmart.reconfiguration.ClientViewManager;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

public class NettyClientPipelineFactory
implements ChannelPipelineFactory {
    NettyClientServerCommunicationSystemClientSide ncs;
    boolean isClient;
    Map sessionTable;
    SecretKey authKey;
    int macLength;
    int signatureLength;
    ClientViewManager manager;
    ReentrantReadWriteLock rl;
    ReentrantLock lock;

    public NettyClientPipelineFactory(NettyClientServerCommunicationSystemClientSide ncs, boolean isClient, Map sessionTable, SecretKey authKey, int macLength, ClientViewManager manager, ReentrantReadWriteLock rl, int signatureLength, ReentrantLock lock) {
        this.ncs = ncs;
        this.isClient = isClient;
        this.sessionTable = sessionTable;
        this.authKey = authKey;
        this.macLength = macLength;
        this.signatureLength = signatureLength;
        this.rl = rl;
        this.lock = lock;
        this.manager = manager;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline p = Channels.pipeline();
        p.addLast("decoder", (ChannelHandler)new NettyTOMMessageDecoder(this.isClient, this.sessionTable, this.authKey, this.macLength, this.manager, this.rl, this.signatureLength, this.manager.getStaticConf().getUseMACs() == 1));
        p.addLast("encoder", (ChannelHandler)new NettyTOMMessageEncoder(this.isClient, this.sessionTable, this.macLength, this.rl, this.signatureLength, this.manager.getStaticConf().getUseMACs() == 1));
        p.addLast("handler", (ChannelHandler)this.ncs);
        return p;
    }
}

