/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication;

import bftsmart.communication.MessageHandler;
import bftsmart.communication.SystemMessage;
import bftsmart.communication.client.CommunicationSystemServerSide;
import bftsmart.communication.client.CommunicationSystemServerSideFactory;
import bftsmart.communication.client.RequestReceiver;
import bftsmart.communication.server.ServersCommunicationLayer;
import bftsmart.paxosatwar.roles.Acceptor;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.Logger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ServerCommunicationSystem
extends Thread {
    public final long MESSAGE_WAIT_TIME = 100L;
    private LinkedBlockingQueue<SystemMessage> inQueue = null;
    protected MessageHandler messageHandler = new MessageHandler();
    private ServersCommunicationLayer serversConn;
    private CommunicationSystemServerSide clientsConn;
    private ServerViewManager manager;

    public ServerCommunicationSystem(ServerViewManager manager, ServiceReplica replica) throws Exception {
        super("Server CS");
        this.manager = manager;
        this.inQueue = new LinkedBlockingQueue(manager.getStaticConf().getInQueueSize());
        this.serversConn = new ServersCommunicationLayer(manager, this.inQueue, replica);
        this.clientsConn = CommunicationSystemServerSideFactory.getCommunicationSystemServerSide(manager);
    }

    public void joinViewReceived() {
        this.serversConn.joinViewReceived();
    }

    public void updateServersConnections() {
        this.serversConn.updateConnections();
        if (this.clientsConn == null) {
            this.clientsConn = CommunicationSystemServerSideFactory.getCommunicationSystemServerSide(this.manager);
        }
    }

    public void setAcceptor(Acceptor acceptor) {
        this.messageHandler.setAcceptor(acceptor);
    }

    public void setTOMLayer(TOMLayer tomLayer) {
        this.messageHandler.setTOMLayer(tomLayer);
    }

    public void setRequestReceiver(RequestReceiver requestReceiver) {
        if (this.clientsConn == null) {
            this.clientsConn = CommunicationSystemServerSideFactory.getCommunicationSystemServerSide(this.manager);
        }
        this.clientsConn.setRequestReceiver(requestReceiver);
    }

    @Override
    public void run() {
        long count = 0L;
        while (true) {
            try {
                while (true) {
                    SystemMessage sm;
                    if (count % 1000L == 0L && count > 0L) {
                        Logger.println("(ServerCommunicationSystem.run) After " + count + " messages, inQueue size=" + this.inQueue.size());
                    }
                    if ((sm = this.inQueue.poll(100L, TimeUnit.MILLISECONDS)) != null) {
                        Logger.println("<-------receiving---------- " + sm);
                        this.messageHandler.processData(sm);
                        ++count;
                        continue;
                    }
                    this.messageHandler.verifyPending();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public void send(int[] targets, SystemMessage sm) {
        if (sm instanceof TOMMessage) {
            this.clientsConn.send(targets, (TOMMessage)sm, false);
        } else {
            Logger.println("--------sending----------> " + sm);
            this.serversConn.send(targets, sm, true);
        }
    }

    public ServersCommunicationLayer getServersConn() {
        return this.serversConn;
    }

    public CommunicationSystemServerSide getClientsConn() {
        return this.clientsConn;
    }

    @Override
    public String toString() {
        return this.serversConn.toString();
    }
}

