/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication;

import bftsmart.communication.SystemMessage;
import bftsmart.paxosatwar.messages.PaxosMessage;
import bftsmart.paxosatwar.roles.Acceptor;
import bftsmart.statemanagement.SMMessage;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.timer.ForwardedMessage;
import bftsmart.tom.leaderchange.LCMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class MessageHandler {
    private Acceptor acceptor;
    private TOMLayer tomLayer;
    private Cipher cipher;
    private Logger logger = Logger.getLogger((String)"divdb");

    public MessageHandler() {
        try {
            this.cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            ex.printStackTrace();
        }
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void setTOMLayer(TOMLayer tomLayer) {
        this.tomLayer = tomLayer;
    }

    protected void processData(SystemMessage sm) {
        if (sm instanceof PaxosMessage) {
            int myId = this.tomLayer.reconfManager.getStaticConf().getProcessId();
            PaxosMessage paxosMsg = (PaxosMessage)sm;
            if (paxosMsg.authenticated || paxosMsg.getSender() == myId) {
                this.acceptor.deliver(paxosMsg);
            } else if (paxosMsg.getPaxosType() == 44783 && paxosMsg.getMACVector() != null) {
                HashMap macVector = (HashMap)paxosMsg.getMACVector();
                byte[] recvMAC = (byte[])macVector.get(myId);
                PaxosMessage pm = new PaxosMessage(44783, paxosMsg.getNumber(), paxosMsg.getRound(), paxosMsg.getSender(), paxosMsg.getValue());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
                try {
                    new ObjectOutputStream(bOut).writeObject(pm);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                byte[] data = bOut.toByteArray();
                byte[] hash = this.tomLayer.computeHash(data);
                byte[] myMAC = null;
                SecretKeySpec key = new SecretKeySpec(this.tomLayer.getCommunication().getServersConn().getSecretKey(paxosMsg.getSender()).getEncoded(), "DES");
                try {
                    this.cipher.init(1, key);
                    myMAC = this.cipher.doFinal(hash);
                }
                catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
                    ex.printStackTrace();
                }
                if (recvMAC != null && myMAC != null && Arrays.equals(recvMAC, myMAC)) {
                    this.acceptor.deliver(paxosMsg);
                } else {
                    System.out.println("(MessageHandler.processData) WARNING: invalid MAC from " + sm.getSender());
                }
            } else {
                System.out.println("(MessageHandler.processData) Discarding unauthenticated message from " + sm.getSender());
            }
        } else if (sm.authenticated) {
            if (sm instanceof LCMessage) {
                LCMessage lcMsg = (LCMessage)sm;
                String type = null;
                switch (lcMsg.getType()) {
                    case 3: {
                        type = "STOP";
                        break;
                    }
                    case 4: {
                        type = "STOPDATA";
                        break;
                    }
                    case 5: {
                        type = "SYNC";
                        break;
                    }
                    default: {
                        type = "LOCAL";
                    }
                }
                System.out.println("(MessageHandler.processData) LC_MSG received: type " + type + ", regency " + lcMsg.getReg() + ", (replica " + lcMsg.getSender() + ")");
                if (lcMsg.TRIGGER_LC_LOCALLY) {
                    this.tomLayer.requestsTimer.run_lc_protocol();
                } else {
                    this.tomLayer.deliverTimeoutRequest(lcMsg);
                }
            } else if (sm instanceof ForwardedMessage) {
                TOMMessage request = ((ForwardedMessage)sm).getRequest();
                this.tomLayer.requestReceived(request);
            } else if (sm instanceof SMMessage) {
                SMMessage smsg = (SMMessage)sm;
                String type = null;
                switch (smsg.getType()) {
                    case 6: {
                        type = "SM_REQUEST";
                        break;
                    }
                    case 7: {
                        type = "SM_REPLY";
                        break;
                    }
                    default: {
                        type = "LOCAL";
                    }
                }
                if (smsg.TRIGGER_SM_LOCALLY) {
                    this.tomLayer.getStateManager().stateTimeout();
                } else if (smsg.getType() == 6) {
                    this.tomLayer.getStateManager().SMRequestDeliver(smsg, this.tomLayer.reconfManager.getStaticConf().isBFT());
                } else {
                    this.tomLayer.getStateManager().SMReplyDeliver(smsg, this.tomLayer.reconfManager.getStaticConf().isBFT());
                }
            } else {
                this.logger.debug((Object)("UNKNOWN MESSAGE TYPE: " + sm));
                System.out.println("UNKNOWN MESSAGE TYPE: " + sm);
            }
        } else {
            this.logger.debug((Object)("(MessageHandler.processData) Discarding unauthenticated message from " + sm.getSender()));
            System.out.println("(MessageHandler.processData) Discarding unauthenticated message from " + sm.getSender());
        }
    }

    protected void verifyPending() {
        this.tomLayer.processOutOfContext();
    }
}

