/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.clientsmanagement;

import bftsmart.clientsmanagement.ClientData;
import bftsmart.clientsmanagement.RequestList;
import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.timer.RequestsTimer;
import bftsmart.tom.util.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class ClientsManager {
    private ServerViewManager manager;
    private RequestsTimer timer;
    private HashMap<Integer, ClientData> clientsData = new HashMap();
    private ReentrantLock clientsLock = new ReentrantLock();

    public ClientsManager(ServerViewManager manager, RequestsTimer timer) {
        this.manager = manager;
        this.timer = timer;
    }

    public ClientData getClientData(int clientId) {
        this.clientsLock.lock();
        ClientData clientData = this.clientsData.get(clientId);
        if (clientData == null) {
            Logger.println("(ClientsManager.getClientData) Creating new client data, client id=" + clientId);
            clientData = new ClientData(clientId, this.manager.getStaticConf().getUseSignatures() == 1 ? this.manager.getStaticConf().getRSAPublicKey() : null);
            this.clientsData.put(clientId, clientData);
        }
        this.clientsLock.unlock();
        return clientData;
    }

    public RequestList getPendingRequests() {
        RequestList allReq = new RequestList();
        this.clientsLock.lock();
        Set<Map.Entry<Integer, ClientData>> clientsEntrySet = this.clientsData.entrySet();
        int i = 0;
        while (true) {
            Iterator<Map.Entry<Integer, ClientData>> it = clientsEntrySet.iterator();
            int noMoreMessages = 0;
            while (it.hasNext() && allReq.size() < this.manager.getStaticConf().getMaxBatchSize() && noMoreMessages < clientsEntrySet.size()) {
                ClientData clientData = it.next().getValue();
                RequestList clientPendingRequests = clientData.getPendingRequests();
                clientData.clientLock.lock();
                TOMMessage request = clientPendingRequests.size() > i ? (TOMMessage)clientPendingRequests.get(i) : null;
                clientData.clientLock.unlock();
                if (request != null) {
                    if (request.alreadyProposed) continue;
                    request.alreadyProposed = true;
                    allReq.addLast(request);
                    continue;
                }
                ++noMoreMessages;
            }
            if (allReq.size() == this.manager.getStaticConf().getMaxBatchSize() || noMoreMessages == clientsEntrySet.size()) break;
            ++i;
        }
        this.clientsLock.unlock();
        return allReq;
    }

    public boolean havePendingRequests() {
        boolean havePending = false;
        this.clientsLock.lock();
        Iterator<Map.Entry<Integer, ClientData>> it = this.clientsData.entrySet().iterator();
        while (it.hasNext() && !havePending) {
            ClientData clientData = it.next().getValue();
            clientData.clientLock.lock();
            RequestList reqs = clientData.getPendingRequests();
            if (!reqs.isEmpty()) {
                for (TOMMessage msg : reqs) {
                    if (msg.alreadyProposed) continue;
                    havePending = true;
                    break;
                }
            }
            clientData.clientLock.unlock();
        }
        this.clientsLock.unlock();
        return havePending;
    }

    public boolean isPending(int reqId) {
        return this.getPending(reqId) != null;
    }

    public TOMMessage getPending(int reqId) {
        ClientData clientData = this.getClientData(TOMMessage.getSenderFromId(reqId));
        clientData.clientLock.lock();
        TOMMessage pendingMessage = clientData.getPendingRequests().getById(reqId);
        clientData.clientLock.unlock();
        return pendingMessage;
    }

    public boolean requestReceived(TOMMessage request, boolean fromClient) {
        return this.requestReceived(request, fromClient, null);
    }

    public boolean requestReceived(TOMMessage request, boolean fromClient, ServerCommunicationSystem cs) {
        request.receptionTime = System.nanoTime();
        int clientId = request.getSender();
        boolean accounted = false;
        ClientData clientData = this.getClientData(clientId);
        clientData.clientLock.lock();
        if (fromClient && this.manager.getStaticConf().getUseControlFlow() != 0 && clientData.getPendingRequests().size() > this.manager.getStaticConf().getUseControlFlow()) {
            clientData.setLastMessageReceived(request.getSequence());
            clientData.setLastMessageReceivedTime(request.receptionTime);
            clientData.clientLock.unlock();
            return false;
        }
        if (clientData.getSession() != request.getSession()) {
            clientData.setSession(request.getSession());
            clientData.setLastMessageReceived(-1);
        }
        if (clientData.getLastMessageReceived() == -1 || clientData.getLastMessageReceived() + 1 == request.getSequence() || request.getSequence() > clientData.getLastMessageReceived() && !fromClient) {
            if (!request.signed || clientData.verifySignature(request.serializedMessage, request.serializedMessageSignature)) {
                clientData.getPendingRequests().add(request);
                clientData.setLastMessageReceived(request.getSequence());
                clientData.setLastMessageReceivedTime(request.receptionTime);
                if (this.timer != null) {
                    this.timer.watch(request);
                }
                accounted = true;
            }
        } else if (clientData.getLastMessageReceived() >= request.getSequence()) {
            TOMMessage reply = clientData.getReply(request.getId());
            if (reply != null && cs != null) {
                cs.send(new int[]{request.getSender()}, reply);
            }
            accounted = true;
        } else {
            accounted = false;
        }
        clientData.clientLock.unlock();
        return accounted;
    }

    public void requestsOrdered(TOMMessage[] requests) {
        this.clientsLock.lock();
        TOMMessage[] tOMMessageArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            TOMMessage request = tOMMessageArray[n2];
            this.requestOrdered(request);
            ++n2;
        }
        this.clientsLock.unlock();
    }

    private void requestOrdered(TOMMessage request) {
        if (this.timer != null) {
            this.timer.unwatch(request);
        }
        ClientData clientData = this.getClientData(request.getSender());
        clientData.clientLock.lock();
        if (!clientData.removeOrderedRequest(request)) {
            Logger.println("(ClientsManager.requestOrdered) Request " + request + " does not exist in pending requests");
        }
        clientData.setLastMessageExecuted(request.getSequence());
        clientData.clientLock.unlock();
    }

    public ReentrantLock getClientsLock() {
        return this.clientsLock;
    }
}

