/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.DeleteClause;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.jpa.hibernate.StatelessSessionHolder;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Predicate;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StatelessSession;

public class HibernateDeleteClause
implements DeleteClause<HibernateDeleteClause> {
    private final QueryMetadata md = new DefaultQueryMetadata();
    private final SessionHolder session;
    private final JPQLTemplates templates;

    public HibernateDeleteClause(Session session, EntityPath<?> entity) {
        this(new DefaultSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateDeleteClause(StatelessSession session, EntityPath<?> entity) {
        this(new StatelessSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateDeleteClause(Session session, EntityPath<?> entity, JPQLTemplates templates) {
        this(new DefaultSessionHolder(session), entity, templates);
    }

    public HibernateDeleteClause(SessionHolder session, EntityPath<?> entity, JPQLTemplates templates) {
        this.session = session;
        this.templates = templates;
        this.md.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates);
        serializer.serializeForDelete(this.md);
        Map constants = serializer.getConstantToLabel();
        Query query = this.session.createQuery(serializer.toString());
        HibernateUtil.setConstants(query, constants, this.md.getParams());
        return query.executeUpdate();
    }

    public HibernateDeleteClause where(Predicate ... o) {
        this.md.addWhere(o);
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates);
        serializer.serializeForDelete(this.md);
        return serializer.toString();
    }
}

