/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.toolkit.xmlrpc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.XmlRpcInvocationException;
import pt.efacec.toolkit.xmlrpc.CustomXmlRpcCommonsTransportFactory;
import pt.efacec.toolkit.xmlrpc.XmlRpcAlias;

public class XmlRpcUtil {
    public static final int CONNECTION_TIMEOUT = 60000;
    public static final int REPLY_TIMEOUT = 60000;

    public static Object write(Object object) {
        if (object == null || object instanceof Boolean || object instanceof Number || object instanceof String || object instanceof Character || object instanceof Date) {
            return object;
        }
        if (object.getClass().isArray()) {
            return XmlRpcUtil.writeArray(object);
        }
        if (object instanceof Collection) {
            return XmlRpcUtil.writeArray(((Collection)object).iterator());
        }
        return XmlRpcUtil.writeBean(object);
    }

    private static Object writeArray(Iterator<?> it) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (it.hasNext()) {
            list.add(XmlRpcUtil.write(it.next()));
        }
        return list;
    }

    private static Object writeArray(Object object) {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(object);
        int i = 0;
        while (i < length) {
            list.add(XmlRpcUtil.write(Array.get(object, i)));
            ++i;
        }
        return list;
    }

    private static Map<String, Object> writeBean(Object object) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            int i = 0;
            while (i < props.length) {
                try {
                    PropertyDescriptor prop = props[i];
                    String name = prop.getName();
                    Method accessor = prop.getReadMethod();
                    if (!"class".equals(name) && accessor != null) {
                        if (!accessor.isAccessible()) {
                            accessor.setAccessible(true);
                        }
                        Object val = accessor.invoke(object, null);
                        XmlRpcAlias xmlRpc = accessor.getAnnotation(XmlRpcAlias.class);
                        if (xmlRpc != null && xmlRpc.value() != null) {
                            name = xmlRpc.value();
                        } else {
                            Field field = XmlRpcUtil.getField(object.getClass(), name);
                            xmlRpc = field.getAnnotation(XmlRpcAlias.class);
                            if (xmlRpc != null && xmlRpc.value() != null) {
                                name = xmlRpc.value();
                            }
                        }
                        if (val != null) {
                            map.put(name, XmlRpcUtil.write(val));
                        }
                    }
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (InvocationTargetException ite) {
                    ite.getCause().printStackTrace();
                    ite.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
        return map;
    }

    public static <T> T read(Object object, Class<T> klazz) {
        return (T)XmlRpcUtil.value(object, klazz, null);
    }

    private static Object value(Object object, Class<?> klazz, Class<?> generic) {
        if (object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Date || object instanceof Character) {
            return object;
        }
        if (object.getClass().isArray()) {
            if (klazz.isArray()) {
                return XmlRpcUtil.readArray(object, klazz.getComponentType());
            }
            if (klazz.isAssignableFrom(List.class)) {
                return XmlRpcUtil.readToList(object, generic);
            }
        } else if (object instanceof List) {
            if (klazz.isArray()) {
                return XmlRpcUtil.readToArray(object, klazz);
            }
            if (klazz.isAssignableFrom(List.class)) {
                return XmlRpcUtil.readList(object, generic);
            }
        } else if (object instanceof Map) {
            return XmlRpcUtil.readBean(object, klazz);
        }
        return null;
    }

    private static Object readToArray(Object object, Class<?> type) {
        List objects = (List)object;
        Object array = Array.newInstance(type, objects.size());
        int f = 0;
        for (Object o : objects) {
            Array.set(array, f, XmlRpcUtil.read(o, type));
            ++f;
        }
        return array;
    }

    private static Object readArray(Object object, Class<?> type) {
        int size = Array.getLength(object);
        Object array = Array.newInstance(type, size);
        int f = 0;
        while (f < size) {
            Object o = Array.get(object, f);
            Array.set(array, f, XmlRpcUtil.read(o, type));
            ++f;
        }
        return array;
    }

    private static Object readToList(Object object, Class<?> type) {
        ArrayList list = new ArrayList();
        int size = Array.getLength(object);
        int f = 0;
        while (f < size) {
            Object o = Array.get(object, f);
            list.add(XmlRpcUtil.read(o, type));
            ++f;
        }
        return list;
    }

    private static Object readList(Object object, Class<?> klazz) {
        ArrayList<Object> list = new ArrayList<Object>();
        List objects = (List)object;
        for (Object o : objects) {
            list.add(XmlRpcUtil.readBean(o, klazz));
        }
        return list;
    }

    private static Object readBean(Object object, Class<?> klazz) {
        Map map = (Map)object;
        Object obj = null;
        if (klazz != null) {
            String name = null;
            try {
                obj = klazz.newInstance();
                BeanInfo info = Introspector.getBeanInfo(klazz);
                PropertyDescriptor[] props = info.getPropertyDescriptors();
                int i = 0;
                while (i < props.length) {
                    Method accessor;
                    PropertyDescriptor prop = props[i];
                    name = prop.getName();
                    if (!"class".equals(name) && (accessor = prop.getWriteMethod()) != null) {
                        XmlRpcAlias xmlRpc = accessor.getAnnotation(XmlRpcAlias.class);
                        if (xmlRpc != null && xmlRpc.value() != null) {
                            name = xmlRpc.value();
                        } else {
                            Field field = XmlRpcUtil.getField(klazz, name);
                            xmlRpc = field.getAnnotation(XmlRpcAlias.class);
                            if (xmlRpc != null && xmlRpc.value() != null) {
                                name = xmlRpc.value();
                            }
                        }
                        for (Map.Entry entry : map.entrySet()) {
                            Object o;
                            if (!((String)entry.getKey()).equalsIgnoreCase(name)) continue;
                            if (!accessor.isAccessible()) {
                                accessor.setAccessible(true);
                            }
                            if ((o = entry.getValue()) == null) continue;
                            Class<?> k = accessor.getParameterTypes()[0];
                            Class<?> generic = XmlRpcUtil.genericClass(accessor);
                            o = XmlRpcUtil.value(o, k, generic);
                            accessor.invoke(obj, o);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    private static Field getField(Class<?> type, String name) {
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals(name)) {
                return field;
            }
            ++n2;
        }
        if (type.getSuperclass() != null) {
            return XmlRpcUtil.getField(type.getSuperclass(), name);
        }
        return null;
    }

    private static Class<?> genericClass(Method method) {
        return XmlRpcUtil.genericClass(method.getGenericParameterTypes()[0]);
    }

    public static Class<?> genericClass(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericType;
            if (aType.getActualTypeArguments()[0] instanceof GenericArrayType) {
                Class c = (Class)((GenericArrayType)aType.getActualTypeArguments()[0]).getGenericComponentType();
                try {
                    return Class.forName("[L" + c.getName() + ";");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return (Class)aType.getActualTypeArguments()[0];
        }
        return null;
    }

    public static <T> T clientInstance(Class<T> klass, String url) {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setEnabledForExtensions(false);
        config.setConnectionTimeout(60000);
        config.setReplyTimeout(60000);
        try {
            config.setServerURL(new URL(url));
            XmlRpcClient client = new XmlRpcClient();
            client.setTransportFactory((XmlRpcTransportFactory)new CustomXmlRpcCommonsTransportFactory(client));
            client.setConfig((XmlRpcClientConfig)config);
            return XmlRpcUtil.clientInstance(klass, client);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T clientInstance(Class<T> klass, final XmlRpcClient client) {
        String remote = klass.getSimpleName();
        XmlRpcAlias alias = klass.getAnnotation(XmlRpcAlias.class);
        if (alias != null) {
            remote = alias.value();
        }
        final String pRemoteName = remote;
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{klass}, new InvocationHandler(){

            /*
             * Unable to fully structure code
             */
            @Override
            public Object invoke(Object pProxy, Method pMethod, Object[] pArgs) throws Throwable {
                block8: {
                    name = pMethod.getName();
                    alias = pMethod.getAnnotation(XmlRpcAlias.class);
                    if (alias != null) {
                        name = alias.value();
                    }
                    methodName = pRemoteName == null || pRemoteName.length() == 0 ? name : String.valueOf(pRemoteName) + "." + name;
                    try {
                        args = null;
                        if (pArgs != null) {
                            args = new Object[pArgs.length];
                            i = 0;
                            while (i < args.length) {
                                args[i] = XmlRpcUtil.write(pArgs[i]);
                                ++i;
                            }
                        }
                        result = client.execute(methodName, args);
                        break block8;
                    }
                    catch (XmlRpcInvocationException e) {
                        t = e.linkedException;
                        if (t instanceof RuntimeException) {
                            throw t;
                        }
                        exceptionTypes = pMethod.getExceptionTypes();
                        i = 0;
                        ** while (i < exceptionTypes.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        c = exceptionTypes[i];
                        if (c.isAssignableFrom(t.getClass())) {
                            throw t;
                        }
                        ++i;
                        continue;
                    }
lbl29:
                    // 1 sources

                    throw new UndeclaredThrowableException(t);
                }
                return XmlRpcUtil.read(result, pMethod.getReturnType());
            }
        });
    }
}

