/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.toolkit.xmlrpc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcCommonsTransport;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.client.XmlRpcTransport;

public class CustomXmlRpcCommonsTransportFactory
extends XmlRpcCommonsTransportFactory {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    public CustomXmlRpcCommonsTransportFactory(XmlRpcClient pClient) {
        super(pClient);
    }

    public XmlRpcTransport getTransport() {
        return new LoggingTransport(this);
    }

    private class LoggingTransport
    extends XmlRpcCommonsTransport {
        public LoggingTransport(CustomXmlRpcCommonsTransportFactory pFactory) {
            super((XmlRpcCommonsTransportFactory)pFactory);
        }

        protected void writeRequest(XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException {
            super.writeRequest(pWriter);
            if (CustomXmlRpcCommonsTransportFactory.this.logger.isDebugEnabled()) {
                ByteArrayOutputStream bos = null;
                try {
                    try {
                        CustomXmlRpcCommonsTransportFactory.this.logger.debug((Object)"---- Request ----");
                        bos = new ByteArrayOutputStream();
                        this.method.getRequestEntity().writeRequest((OutputStream)bos);
                        CustomXmlRpcCommonsTransportFactory.this.logger.debug((Object)bos.toString());
                    }
                    catch (IOException e) {
                        throw new XmlRpcException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)bos);
            }
        }

        protected InputStream getInputStream() throws XmlRpcException {
            InputStream istream = super.getInputStream();
            if (CustomXmlRpcCommonsTransportFactory.this.logger.isDebugEnabled()) {
                ByteArrayInputStream byteArrayInputStream;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(istream));
                    String line = null;
                    StringBuilder respBuf = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        respBuf.append(line);
                    }
                    String response = respBuf.toString();
                    CustomXmlRpcCommonsTransportFactory.this.logger.debug((Object)"---- Response ----");
                    CustomXmlRpcCommonsTransportFactory.this.logger.debug((Object)respBuf.toString());
                    byteArrayInputStream = new ByteArrayInputStream(response.getBytes());
                }
                catch (IOException e) {
                    try {
                        throw new XmlRpcException(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
                return byteArrayInputStream;
            }
            return istream;
        }
    }
}

