/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.toolkit.spring;

import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import pt.efacec.toolkit.misc.EncryptedProperties;

public abstract class EncryptedPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final String PREFIX = "ENC(";
    private static final String SUFFIX = ")";
    private EncryptedProperties encryptedProperties = null;

    public EncryptedPropertyPlaceholderConfigurer() {
        try {
            this.encryptedProperties = new EncryptedProperties(this.getEncKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value = props.getProperty(placeholder);
        if (value != null && value.startsWith(PREFIX) && value.endsWith(SUFFIX)) {
            String enc = value.substring(PREFIX.length(), value.length() - SUFFIX.length());
            try {
                return this.encryptedProperties.decrypt(enc);
            }
            catch (Exception e) {
                e.printStackTrace();
                return enc;
            }
        }
        return value;
    }

    protected abstract String getEncKey();
}

