/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.toolkit.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import pt.efacec.toolkit.misc.Labeled;
import pt.efacec.toolkit.misc.Log;
import pt.efacec.toolkit.misc.Matcher;
import pt.efacec.toolkit.misc.Transformer;

public class Tool {
    private static final Log logger = Log.getLogger(Tool.class);
    private static final byte[] buffer = new byte[1024];
    public static final Comparator<Labeled> LABELED_COMPARATOR = new Comparator<Labeled>(){

        @Override
        public int compare(Labeled o1, Labeled o2) {
            boolean exists2;
            boolean exists1 = o1 != null && o1.getLabel() != null;
            boolean bl = exists2 = o2 != null && o2.getLabel() != null;
            if (!exists1 && !exists2) {
                return 0;
            }
            if (exists1 && !exists2) {
                return 1;
            }
            if (!exists1 && exists2) {
                return -1;
            }
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };

    public static SSLSocketFactory getSocketFactory(String keyStorePath, String keyStorePassword) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        File pKeyFile = new File(keyStorePath);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream keyInput = new FileInputStream(pKeyFile);
        keyStore.load(keyInput, keyStorePassword.toCharArray());
        ((InputStream)keyInput).close();
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        return context.getSocketFactory();
    }

    public static Properties loadProperties(String propsName) {
        Properties props = new Properties();
        URL url = ClassLoader.getSystemResource(propsName);
        try {
            props.load(url.openStream());
        }
        catch (IOException e) {
            logger.warn("=====> \"" + propsName + "\" wasn't found.");
            return null;
        }
        return props;
    }

    public static Properties loadProperties(File fx) {
        Properties properties = new Properties();
        if (fx.exists()) {
            try {
                properties.load(new FileInputStream(fx));
            }
            catch (Exception e) {
                logger.warn("=====> unable to load \"" + fx.getAbsolutePath() + "\".");
                throw new RuntimeException("=====> unable to load \"" + fx.getAbsolutePath() + "\".", e);
            }
        } else {
            logger.warn("=====> \"" + fx.getAbsolutePath() + "\" wasn't found.");
            return null;
        }
        return properties;
    }

    public static <T extends Comparable<T>> int compareTo(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    public static <T> boolean similar(T o1, T o2) {
        return Tool.similar(o1, o2, null);
    }

    public static <T> boolean similar(T o1, T o2, Matcher<T> matcher) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            if (matcher != null) {
                return matcher.isMatch(o1, o2);
            }
            return o1.equals(o2);
        }
        return false;
    }

    @SafeVarargs
    public static <T> T notNull(T ... tests) {
        T test = null;
        T[] TArray = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            test = t;
            if (t != null) {
                return t;
            }
            ++n2;
        }
        return test;
    }

    public static <T> T toNull(T test, T value) {
        if (test == null || test.equals(value)) {
            return null;
        }
        return test;
    }

    public static void zip(String name, InputStream in, ZipOutputStream out) throws IOException {
        int len;
        out.putNextEntry(new ZipEntry(name));
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.closeEntry();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException(String.valueOf(file.getName()) + " is too big!");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static <S, T> List<T> filterCollection(List<S> srcList, Transformer<S, T> transformer) {
        return Tool.transformCollection(srcList, transformer, false);
    }

    public static <S, T> List<T> transformCollection(List<S> srcList, Transformer<S, T> transformer) {
        return Tool.transformCollection(srcList, transformer, true);
    }

    public static <S, T> List<T> transformCollection(List<S> srcList, Transformer<S, T> transformer, boolean allowNull) {
        if (srcList == null) {
            return null;
        }
        ArrayList<T> dest = new ArrayList<T>();
        for (S child : srcList) {
            T transformed = transformer.transform(child);
            if (!allowNull && transformed == null) continue;
            dest.add(transformed);
        }
        return dest;
    }

    public static boolean hasStackedException(Throwable e, Class<?> clazz) {
        if (e == null) {
            return false;
        }
        if (clazz.isAssignableFrom(e.getClass())) {
            return true;
        }
        return Tool.hasStackedException(e.getCause(), clazz);
    }

    public static boolean isPortAvailable(int port) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            return true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static <T> List<T> subList(List<T> list, int fromIndex) {
        return Tool.subList(list, fromIndex, -1);
    }

    public static <T> List<T> subList(List<T> list, int fromIndex, int size) {
        if (list == null) {
            return null;
        }
        if (fromIndex > list.size()) {
            return new ArrayList();
        }
        int toIndex = size < 0 || fromIndex + size > list.size() ? list.size() : fromIndex + size;
        return list.subList(fromIndex < 0 ? 0 : fromIndex, toIndex);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T lowest(T ... objs) {
        Object obj = null;
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object c = TArray[n2];
            if (obj == null) {
                obj = c;
            } else if (c.compareTo(obj) == -1) {
                obj = c;
            }
            ++n2;
        }
        return obj;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T highest(T ... objs) {
        Object obj = null;
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object c = TArray[n2];
            if (obj == null) {
                obj = c;
            } else if (c.compareTo(obj) == 1) {
                obj = c;
            }
            ++n2;
        }
        return obj;
    }
}

