/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.toolkit.misc;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Strings {
    private static final String ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int DERIVED_KEY_LENGTH = 160;
    private static final int ITERATIONS = 20000;
    private static final int SALT_LENGTH = 8;
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";

    public static String trimLine(String str, int maxSize) {
        if (str.length() > maxSize) {
            return String.valueOf(str.substring(0, maxSize - 4)) + "...";
        }
        return str;
    }

    public static List<String> toStringList(List<?> e) {
        ArrayList<String> res = new ArrayList<String>();
        for (Object t : e) {
            res.add(t.toString());
        }
        return res;
    }

    public static String joinList(List<?> e, String joiner) {
        StringBuilder sb = new StringBuilder();
        boolean notFirst = false;
        for (Object t : e) {
            if (notFirst) {
                sb.append(joiner);
            }
            sb.append(t.toString());
            notFirst = true;
        }
        return sb.toString();
    }

    public static String asString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static String concat(String original, String fragment, String separator) {
        if (original != null && !original.equals("")) {
            StringBuffer str = new StringBuffer();
            str.append(original).append(separator).append(fragment);
            return str.toString();
        }
        return fragment;
    }

    public static String ltrim(String str, char ch) {
        int f = 0;
        while (f < str.length()) {
            if (str.charAt(f) != ch) {
                return str.substring(f);
            }
            ++f;
        }
        return "";
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static String leftPad(Object what, int width, String txt) {
        String ret = "" + what;
        while (ret.length() < width) {
            ret = String.valueOf(txt) + ret;
        }
        return ret;
    }

    public static String rightPad(Object what, int width, String txt) {
        String ret = "" + what;
        while (ret.length() < width) {
            ret = String.valueOf(ret) + txt;
        }
        return ret;
    }

    public static boolean isNumber(String string) {
        return string.matches("^\\d+$");
    }

    public static boolean isNumeric(String string) {
        return string.matches("^[-+]?\\d+(\\.\\d+)?$");
    }

    public static String getHash(String str, String salt) {
        if (str == null || salt == null) {
            return "";
        }
        String hash = null;
        try {
            PBEKeySpec spec = new PBEKeySpec(str.toCharArray(), Strings.base64ToByte(salt), 20000, 160);
            SecretKeyFactory f = SecretKeyFactory.getInstance(ALGORITHM);
            return Strings.byteToBase64(f.generateSecret(spec).getEncoded());
        }
        catch (Exception e) {
            e.printStackTrace();
            return hash;
        }
    }

    public static String generateSalt() {
        byte[] salt = new byte[8];
        try {
            SecureRandom random = SecureRandom.getInstance(RANDOM_ALGORITHM);
            random.nextBytes(salt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Strings.byteToBase64(salt);
    }

    public static byte[] base64ToByte(String str) throws IOException {
        Base64 base64 = new Base64();
        return base64.decode(str);
    }

    public static String byteToBase64(byte[] data) {
        Base64 base64 = new Base64();
        return base64.encodeToString(data);
    }

    public static Integer toInteger(String str, Integer def) {
        if (!Strings.isEmpty(str)) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public static Long toLong(String str, Long def) {
        if (!Strings.isEmpty(str)) {
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }
}

