/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.toolkit.misc;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PackageScanner {
    private String rootPackage;

    public PackageScanner(String rootPackage) {
        this.rootPackage = rootPackage;
    }

    public boolean accept(Class<?> clazz) {
        return true;
    }

    public List<Class<?>> scan() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            assert (classLoader != null);
            String path = this.rootPackage.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            ArrayList<String> dirs = new ArrayList<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(resource.getFile());
            }
            TreeSet<String> classes = new TreeSet<String>();
            for (String directory : dirs) {
                classes.addAll(PackageScanner.findClasses(directory, this.rootPackage));
            }
            ArrayList classList = new ArrayList();
            for (String clazz : classes) {
                Class<?> k = Class.forName(clazz);
                if (!this.accept(k)) continue;
                classList.add(k);
            }
            return classList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static TreeSet<String> findClasses(String path, String packageName) throws Exception {
        File[] files;
        File dir;
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            ZipEntry entry;
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || entry.getName().contains("$") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName)) continue;
                classes.add(className);
            }
        }
        if (!(dir = new File(path)).exists()) {
            return classes;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(PackageScanner.findClasses(file.getAbsolutePath(), String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(".class") && !file.getName().contains("$")) {
                String className = String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6);
                classes.add(className);
            }
            ++n2;
        }
        return classes;
    }
}

