/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.toolkit.misc;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class ImageLabel {
    private static final Logger logger = Logger.getLogger(ImageLabel.class);
    private static final int BUFFER_WIDTH = 800;
    private static final int BUFFER_HEIGHT = 200;

    public static BufferedImage renderPNG(Font font, String str, Color color) {
        return ImageLabel.renderPNG(font, str, color, Color.BLACK);
    }

    public static BufferedImage renderPNG(Font font, String str, Color color, Color transparency) {
        BufferedImage img = new BufferedImage(800, 200, 2);
        float x = 1.0f;
        float y = 1.0f;
        Graphics2D g2 = img.createGraphics();
        g2.setColor(color);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout layout = new TextLayout(str, font, frc);
        Rectangle2D bounds = layout.getBounds();
        float ox = (float)((double)x - bounds.getX());
        float oy = (float)((double)y - bounds.getY());
        layout.draw(g2, ox, oy);
        BufferedImage bi = img.getSubimage(0, 0, (int)bounds.getWidth() + 3, (int)bounds.getHeight() + 3);
        return ImageLabel.imageToBufferedImage(ImageLabel.makeColorTransparentForPNG(bi, transparency));
    }

    public static Image makeColorTransparentForPNG(BufferedImage im, Color color) {
        RGBImageFilter filter = new RGBImageFilter(color){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    private static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static Font creatFont(InputStream is, int style, int size) {
        Font font = null;
        try {
            font = Font.createFont(0, is);
            font = font.deriveFont(style, size);
            logger.info((Object)("Font " + font.getFontName() + " loaded."));
        }
        catch (Exception ex) {
            logger.warn((Object)"Font not loaded.  Using serif font.", (Throwable)ex);
            font = new Font("serif", style, size);
        }
        return font;
    }
}

