/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.toolkit.misc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Dates {
    public static final long SECOND_IN_MS = 1000L;
    public static final long MINUTE_IN_MS = 60000L;
    public static final long HOUR_IN_MS = 3600000L;
    public static final long DAY_IN_MS = 86400000L;

    public static Date addTimeToDate(Date date, Date time) {
        TimeZone tz = TimeZone.getDefault();
        return Dates.addTimeToDate(tz, date, time);
    }

    public static Date addTimeToDate(TimeZone tz, Date date, Date time) {
        return new Date(date.getTime() + time.getTime() + (long)(tz.inDaylightTime(date) ? 0 : tz.getDSTSavings()));
    }

    public static Date endOfDay(Date date) {
        return Dates.endOf(date, 5);
    }

    public static Date beginOfDay(Date date) {
        return Dates.beginOf(date, 5);
    }

    public static Date endOf(Date date, int type) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        switch (type) {
            case 5: {
                cal.set(11, 23);
            }
            case 11: {
                cal.set(12, 59);
            }
            case 12: {
                cal.set(13, 59);
            }
            case 13: {
                cal.set(14, 999);
            }
        }
        return cal.getTime();
    }

    public static Date beginOf(Date date, int type) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        switch (type) {
            case 5: {
                cal.set(11, 0);
            }
            case 11: {
                cal.set(12, 0);
            }
            case 12: {
                cal.set(13, 0);
            }
            case 13: {
                cal.set(14, 0);
            }
        }
        return cal.getTime();
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        Date time = new Date(10800000L);
        Date date = sdf.parse("25-03-2012");
        System.out.println("===> " + Dates.setTime(date, time));
    }

    public static Date setTime(Date date, Date time) {
        Calendar calDate = GregorianCalendar.getInstance();
        calDate.setTime(date);
        Calendar calTime = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
        calTime.setTime(time);
        calDate.set(11, calTime.get(11));
        calDate.set(12, calTime.get(12));
        calDate.set(13, calTime.get(13));
        calDate.set(14, calTime.get(14));
        return calDate.getTime();
    }

    public static Date truncateToTime(Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        long time = (long)cal.get(11) * 3600000L;
        time += (long)cal.get(12) * 60000L;
        time += (long)cal.get(13) * 1000L;
        return new Date(time += (long)cal.get(14));
    }

    public static Date addOneDay(Date date) {
        return Dates.moveDays(date, 1);
    }

    public static Date removeOneDay(Date date) {
        return Dates.moveDays(date, -1);
    }

    public static Date moveDays(Date date, int days) {
        return Dates.moveDate(date, 5, days);
    }

    public static Date moveDate(Date date, int tipo, int amount) {
        if (date == null) {
            return null;
        }
        if (amount == 0) {
            return date;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.add(tipo, amount);
        return cal.getTime();
    }
}

