/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.domain;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import pt.efacec.smartlighting.common.domain.EModeExtended;
import pt.efacec.toolkit.misc.Tool;

public class StandardPeriodDTO
implements Comparable<StandardPeriodDTO>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DATE_FORMAT = "dd-MM-yyyy";
    public static final String SHORT_TIME_FORMAT = "HH:mm";
    protected Date start;
    protected Date end;
    protected EModeExtended offMode;
    protected Date offTime;
    protected Long offOffset;
    protected EModeExtended onMode;
    protected Date onTime;
    protected Long onOffset;

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public EModeExtended getOnMode() {
        return this.onMode;
    }

    public void setOnMode(EModeExtended onMode) {
        this.onMode = onMode;
    }

    public Date getOnTime() {
        return this.onTime;
    }

    public void setOnTime(Date onTime) {
        this.onTime = onTime;
    }

    public Long getOnOffset() {
        return this.onOffset;
    }

    public void setOnOffset(Long onOffset) {
        this.onOffset = onOffset;
    }

    public EModeExtended getOffMode() {
        return this.offMode;
    }

    public void setOffMode(EModeExtended offMode) {
        this.offMode = offMode;
    }

    public Date getOffTime() {
        return this.offTime;
    }

    public void setOffTime(Date offTime) {
        this.offTime = offTime;
    }

    public Long getOffOffset() {
        return this.offOffset;
    }

    public void setOffOffset(Long offOffset) {
        this.offOffset = offOffset;
    }

    public StandardPeriodDTO() {
    }

    public StandardPeriodDTO(StandardPeriodDTO dto) {
        this.copy(dto);
    }

    public StandardPeriodDTO(Date start, Date end, EModeExtended offMode, Date offTime, Long offOffset, EModeExtended onMode, Date onTime, Long onOffset) {
        this.start = start;
        this.end = end;
        this.onMode = onMode;
        this.onTime = onTime;
        this.onOffset = onOffset;
        this.offMode = offMode;
        this.offTime = offTime;
        this.offOffset = offOffset;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        SimpleDateFormat hm = new SimpleDateFormat(SHORT_TIME_FORMAT);
        hm.setTimeZone(TimeZone.getTimeZone("UTC"));
        StringBuilder builder = new StringBuilder();
        builder.append("{start=");
        builder.append(this.start != null ? sdf.format(this.start) : "null");
        builder.append(", end=");
        builder.append(this.end != null ? sdf.format(this.end) : "null");
        builder.append(", offMode=");
        builder.append(this.offMode);
        builder.append(", offTime=");
        builder.append(this.offTime != null ? hm.format(this.offTime) : "null");
        builder.append(", offOffset=");
        builder.append(this.offOffset);
        builder.append(", onMode=");
        builder.append(this.onMode);
        builder.append(", onTime=");
        builder.append(this.onTime != null ? hm.format(this.onTime) : "null");
        builder.append(", onOffset=");
        builder.append(this.onOffset);
        builder.append("}");
        return builder.toString();
    }

    public void copy(Object o) {
        if (o != null && o instanceof StandardPeriodDTO) {
            StandardPeriodDTO dto = (StandardPeriodDTO)o;
            this.setStart(dto.getStart());
            this.setEnd(dto.getEnd());
            this.setOnMode(dto.getOnMode());
            this.setOnTime(dto.getOnTime());
            this.setOnOffset(dto.getOnOffset());
            this.setOffMode(dto.getOffMode());
            this.setOffTime(dto.getOffTime());
            this.setOffOffset(dto.getOffOffset());
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof StandardPeriodDTO) {
            StandardPeriodDTO dto = (StandardPeriodDTO)o;
            return this.equalsProperties(dto);
        }
        return false;
    }

    protected boolean equalsProperties(StandardPeriodDTO dto) {
        return Tool.similar(this.start, dto.getStart()) && Tool.similar(this.end, dto.getEnd()) && Tool.similar(this.onMode, dto.getOnMode()) && Tool.similar(this.onTime, dto.getOnTime()) && Tool.similar(this.onOffset, dto.getOnOffset()) && Tool.similar(this.offMode, dto.getOffMode()) && Tool.similar(this.offTime, dto.getOffTime()) && Tool.similar(this.offOffset, dto.getOffOffset());
    }

    @Override
    public int compareTo(StandardPeriodDTO o) {
        return this.start.compareTo(o.getStart());
    }
}

