/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.domain;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import pt.efacec.smartlighting.common.domain.ETimeTableType;
import pt.efacec.smartlighting.common.domain.StandardPeriodDTO;
import pt.efacec.toolkit.misc.Dates;
import pt.efacec.toolkit.misc.Tool;

public class DtcServiceTimeTable
implements Comparable<DtcServiceTimeTable>,
Serializable {
    private static final long serialVersionUID = -1936760383823196841L;
    private String name;
    private ETimeTableType type;
    private List<StandardPeriodDTO> entries = new ArrayList<StandardPeriodDTO>();

    public DtcServiceTimeTable(DtcServiceTimeTable timetable) {
        this.name = timetable.getName();
        this.type = timetable.type;
        this.setEntries(timetable.getEntries());
    }

    public DtcServiceTimeTable(String name) {
        this(name, null);
    }

    public DtcServiceTimeTable(String name, ETimeTableType type) {
        this.name = name;
        this.type = type;
    }

    public DtcServiceTimeTable(String name, ETimeTableType type, List<StandardPeriodDTO> entries) {
        this.name = name;
        this.type = type;
        this.setEntries(entries);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ETimeTableType getType() {
        return this.type;
    }

    public void setType(ETimeTableType type) {
        this.type = type;
    }

    public List<StandardPeriodDTO> getEntries() {
        return this.entries;
    }

    public void setEntries(List<StandardPeriodDTO> entries) {
        this.entries = new ArrayList<StandardPeriodDTO>();
        for (StandardPeriodDTO entry : entries) {
            this.entries.add(new StandardPeriodDTO(entry));
        }
    }

    public void addEntries(List<StandardPeriodDTO> entries) {
        for (StandardPeriodDTO entry : entries) {
            this.addEntry(entry);
        }
    }

    public void addEntry(StandardPeriodDTO period) {
        StandardPeriodDTO entry = new StandardPeriodDTO(period);
        if (this.entries.isEmpty()) {
            this.entries.add(entry);
        } else {
            ArrayList<StandardPeriodDTO> list = new ArrayList<StandardPeriodDTO>();
            boolean include = true;
            for (StandardPeriodDTO e : this.entries) {
                if (this.colide(entry, e)) {
                    this.resolveCollision(entry, e, list, include);
                    include = false;
                    continue;
                }
                if (!include && entry.getStart().before(e.getStart())) {
                    list.add(entry);
                    include = true;
                    list.add(e);
                    continue;
                }
                list.add(e);
            }
            if (include) {
                list.add(entry);
            }
            this.entries = list;
        }
    }

    private boolean colide(StandardPeriodDTO entry, StandardPeriodDTO old) {
        return this.isEdgeInside(entry.getStart().getTime(), old) || entry.getEnd() == null || this.isEdgeInside(entry.getEnd().getTime(), old) || this.isEdgeInside(old.getStart().getTime(), entry) || old.getEnd() == null || this.isEdgeInside(old.getEnd().getTime(), entry);
    }

    private void resolveCollision(StandardPeriodDTO entry, StandardPeriodDTO old, List<StandardPeriodDTO> list, boolean include) {
        if (entry.getStart().getTime() <= old.getStart().getTime()) {
            if (include) {
                list.add(entry);
            }
            if (entry.getEnd() != null && (old.getEnd() == null || old.getEnd().after(entry.getEnd()))) {
                old.setStart(Dates.addOneDay(entry.getEnd()));
                list.add(old);
            }
        } else if (old.getEnd() == null || entry.getStart().getTime() <= old.getEnd().getTime()) {
            Date end = old.getEnd();
            old.setEnd(Dates.removeOneDay(entry.getStart()));
            list.add(old);
            list.add(entry);
            if (entry.getEnd() != null && (end == null || end.after(entry.getEnd()))) {
                StandardPeriodDTO temp = new StandardPeriodDTO(old);
                temp.setStart(Dates.addOneDay(entry.getEnd()));
                temp.setEnd(end);
                list.add(temp);
            }
        }
    }

    private boolean isEdgeInside(long time, StandardPeriodDTO entry) {
        return time >= entry.getStart().getTime() && (entry.getEnd() == null || time <= entry.getEnd().getTime());
    }

    @Override
    public int compareTo(DtcServiceTimeTable other) {
        return Tool.compareTo(this.name, other.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{name=");
        builder.append(this.name);
        builder.append(", entries=");
        builder.append(this.entries);
        builder.append("}");
        return builder.toString();
    }

    public String stringified() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"");
        builder.append(this.name);
        builder.append("\",[");
        for (StandardPeriodDTO entry : this.entries) {
            builder.append(entry.toString());
        }
        builder.append("]}");
        return builder.toString();
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        StandardPeriodDTO ENTRY1 = new StandardPeriodDTO(sdf.parse("05-08-2012"), sdf.parse("10-08-2012"), null, null, null, null, null, null);
        StandardPeriodDTO ENTRY2 = new StandardPeriodDTO(sdf.parse("11-08-2012"), sdf.parse("20-08-2012"), null, null, null, null, null, null);
        StandardPeriodDTO ENTRY3 = new StandardPeriodDTO(sdf.parse("20-08-2012"), sdf.parse("30-08-2012"), null, null, null, null, null, null);
        DtcServiceTimeTable timeTable = null;
        timeTable = new DtcServiceTimeTable("Service #0");
        timeTable.addEntry(new StandardPeriodDTO(sdf.parse("01-08-2012"), sdf.parse("31-08-2012"), null, null, null, null, null, null));
        timeTable.addEntry(new StandardPeriodDTO(sdf.parse("01-08-2012"), sdf.parse("01-08-2012"), null, null, null, null, null, null));
        timeTable.addEntry(new StandardPeriodDTO(sdf.parse("07-08-2012"), sdf.parse("07-08-2012"), null, null, null, null, null, null));
        timeTable.addEntry(new StandardPeriodDTO(sdf.parse("31-08-2012"), sdf.parse("31-08-2012"), null, null, null, null, null, null));
        System.out.println(timeTable.toString());
    }
}

