/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.statemanagement;

import bftsmart.communication.SystemMessage;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.strategy.StandardSMMessage;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.server.Recoverable;
import org.apache.log4j.Logger;

public class StateMessageProcessor
extends Thread {
    private TOMLayer tomLayer;
    private Recoverable recoverable;
    private StandardSMMessage request;
    private int me;
    private ServerViewManager SVManager;
    private Logger logger = Logger.getLogger((String)"divdb");
    private boolean sendState = false;

    public StateMessageProcessor(TOMLayer tomLayer, Recoverable recoverable, StandardSMMessage request) {
        this.tomLayer = tomLayer;
        this.recoverable = recoverable;
        this.request = request;
        this.SVManager = tomLayer.reconfManager;
        this.me = this.SVManager.getStaticConf().getProcessId();
        if (request.getReplica() == this.me) {
            this.sendState = true;
        }
    }

    @Override
    public void run() {
        ApplicationState thisState = this.recoverable.getState(this.request.getEid(), this.sendState);
        if (thisState == null) {
            thisState = this.recoverable.getState(-1, this.sendState);
        }
        int[] targets = new int[]{this.request.getSender()};
        StandardSMMessage smsg = new StandardSMMessage(this.me, this.request.getEid(), 7, -1, thisState, this.SVManager.getCurrentView(), -1, this.tomLayer.lm.getCurrentLeader());
        this.logger.debug((Object)"Sending state");
        this.tomLayer.getCommunication().send(targets, (SystemMessage)smsg);
        this.logger.debug((Object)"Sent");
    }
}

