/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.statemanagement;

import bftsmart.communication.SystemMessage;
import bftsmart.paxosatwar.executionmanager.ExecutionManager;
import bftsmart.paxosatwar.messages.PaxosMessage;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.SMMessage;
import bftsmart.statemanagement.strategy.BaseStateManager;
import bftsmart.statemanagement.strategy.StandardSMMessage;
import bftsmart.tom.core.DeliveryThread;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.server.Recoverable;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import lasige.divdb.comm.Message;
import lasige.divdb.comm.MessageHandler;
import lasige.divdb.statemanagement.DatabaseState;
import org.apache.log4j.Logger;

public class DatabaseStateManager
extends BaseStateManager {
    private DeliveryThread dt;
    private Logger logger = Logger.getLogger((String)"divdb");
    private int replica;
    private ExecutionManager execManager;
    private DatabaseState replicaState;
    private List<DatabaseState> hashes = new ArrayList<DatabaseState>();

    public void SMReplyDeliver(SMMessage msg, boolean isBFT) {
        boolean validState = false;
        DatabaseState state = (DatabaseState)msg.getState();
        this.logger.debug((Object)("Received state from replica " + msg.getSender()));
        if (msg.getSender() == this.replica) {
            this.replicaState = state;
        } else {
            this.hashes.add(state);
        }
        if (this.replicaState != null && this.hashes.size() > 1) {
            validState = true;
        }
        if (validState) {
            this.dt.deliverLock();
            this.waitingEid = -1;
            this.dt.update((ApplicationState)this.replicaState);
            if (!this.appStateOnly && this.execManager.stopped()) {
                Queue stoppedMsgs = this.execManager.getStoppedMsgs();
                for (PaxosMessage stopped : stoppedMsgs) {
                    if (stopped.getNumber() > state.getLastEid()) {
                        this.logger.debug((Object)("adding eid " + stopped.getNumber() + " to out of context"));
                    }
                    this.execManager.addOutOfContextMessage(stopped);
                }
                this.execManager.clearStopped();
                this.execManager.restart();
            }
            this.lastEid = state.getLastEid();
            this.tomLayer.processOutOfContext();
            this.reset();
            this.logger.debug((Object)"I updated the state!");
            this.dt.canDeliver();
            this.dt.deliverUnlock();
            this.tomLayer.requestsTimer.Enabled(true);
            this.tomLayer.requestsTimer.startTimer();
            this.waitingEid = -1;
            this.replicaState = null;
            this.hashes = new ArrayList<DatabaseState>();
        }
    }

    public void SMRequestDeliver(SMMessage msg, boolean isBFT) {
        this.logger.debug((Object)"state asked");
        Recoverable recoverable = this.dt.getRecoverer();
        StandardSMMessage stdMsg = (StandardSMMessage)msg;
        if (this.SVManager.getStaticConf().isStateTransferEnabled() && recoverable != null) {
            ApplicationState thisState = recoverable.getState(stdMsg.getEid(), true);
            if (thisState == null) {
                thisState = recoverable.getState(-1, true);
            }
            int[] targets = new int[]{stdMsg.getSender()};
            int me = this.SVManager.getStaticConf().getProcessId();
            StandardSMMessage smsg = new StandardSMMessage(me, stdMsg.getEid(), 7, -1, thisState, this.SVManager.getCurrentView(), -1, this.tomLayer.lm.getCurrentLeader());
            this.logger.debug((Object)("Sending state to replica " + stdMsg.getSender()));
            this.tomLayer.getCommunication().send(targets, (SystemMessage)smsg);
            this.logger.debug((Object)"Sent");
        }
    }

    public void init(TOMLayer tomLayer, DeliveryThread dt) {
        this.tomLayer = tomLayer;
        this.SVManager = tomLayer.reconfManager;
        this.dt = dt;
        this.replica = 0;
        this.execManager = tomLayer.execManager;
        if (this.replica == this.SVManager.getStaticConf().getProcessId()) {
            this.changeReplica();
        }
        this.state = null;
        this.lastEid = 1;
        this.waitingEid = -1;
        this.appStateOnly = false;
    }

    protected void requestState() {
        if (this.tomLayer.requestsTimer != null) {
            this.tomLayer.requestsTimer.clearAll();
        }
        int me = this.SVManager.getStaticConf().getProcessId();
        this.logger.debug((Object)("I'm sending a request to the other replicas for the state up to EID " + this.waitingEid));
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"error in sleep", (Throwable)e);
        }
        MessageHandler handler = new MessageHandler(me, true);
        StandardSMMessage smsg = new StandardSMMessage(me, this.waitingEid, 6, this.replica, null, null, -1, -1);
        Message reply = handler.requestState((SMMessage)smsg);
        this.logger.debug((Object)("Reply from state request: " + reply.getOpcode()));
    }

    public void stateTimeout() {
    }

    private void changeReplica() {
        int pos = -1;
        do {
            pos = this.SVManager.getCurrentViewPos(this.replica);
            this.replica = this.SVManager.getCurrentViewProcesses()[(pos + 1) % this.SVManager.getCurrentViewN()];
        } while (this.replica == this.SVManager.getStaticConf().getProcessId());
    }
}

