/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.jdbc;

import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialStruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ResultSetData
implements Serializable {
    private static final long serialVersionUID = 4017257435190384824L;
    private final RowSetMetaDataImpl metadata;
    private final ArrayList<ArrayList<Object>> rows;
    private boolean updateOnInsert;
    private int numCols;
    private static Logger logger = Logger.getLogger((String)"divdb");

    public RowSetMetaDataImpl getMetadata() {
        return this.metadata;
    }

    public ArrayList<ArrayList<Object>> getRows() {
        return this.rows;
    }

    public boolean isUpdateOnInsert() {
        return this.updateOnInsert;
    }

    public ResultSetData(ResultSet rs) {
        RowSetMetaDataImpl mdImpl = new RowSetMetaDataImpl();
        try {
            this.initMetaData(mdImpl, rs.getMetaData());
        }
        catch (SQLException e) {
            logger.error((Object)"error initializing meta data");
        }
        this.metadata = mdImpl;
        this.rows = this.populate(rs);
    }

    private void initMetaData(RowSetMetaDataImpl md, ResultSetMetaData rsmd) {
        try {
            this.numCols = rsmd.getColumnCount();
            md.setColumnCount(this.numCols);
            int col = 1;
            while (col <= this.numCols) {
                md.setAutoIncrement(col, rsmd.isAutoIncrement(col));
                if (rsmd.isAutoIncrement(col)) {
                    this.updateOnInsert = true;
                }
                md.setCaseSensitive(col, false);
                md.setCurrency(col, false);
                md.setNullable(col, rsmd.isNullable(col));
                md.setSigned(col, rsmd.isSigned(col));
                md.setSearchable(col, false);
                int size = rsmd.getColumnDisplaySize(col);
                if (size < 0) {
                    size = 0;
                }
                md.setColumnDisplaySize(col, 0);
                if (StringUtils.isNotBlank((String)rsmd.getColumnLabel(col))) {
                    md.setColumnLabel(col, rsmd.getColumnLabel(col).toLowerCase());
                }
                if (StringUtils.isNotBlank((String)rsmd.getColumnName(col))) {
                    md.setColumnName(col, rsmd.getColumnName(col).toLowerCase());
                }
                md.setSchemaName(col, null);
                int precision = rsmd.getPrecision(col);
                if (precision < 0) {
                    precision = 0;
                }
                md.setPrecision(col, 0);
                int scale = rsmd.getScale(col);
                if (scale < 0) {
                    scale = 0;
                }
                md.setScale(col, 0);
                md.setTableName(col, null);
                md.setCatalogName(col, null);
                md.setColumnType(col, -1);
                md.setColumnTypeName(col, null);
                ++col;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error inside initMetaData", (Throwable)e);
        }
    }

    private ArrayList<ArrayList<Object>> populate(ResultSet data) {
        ArrayList<ArrayList<Object>> rows = new ArrayList<ArrayList<Object>>();
        int countRow = 0;
        try {
            while (data.next()) {
                ArrayList<Object> cols = new ArrayList<Object>();
                int countCol = 1;
                int i = 1;
                while (i <= this.numCols) {
                    Object obj = data.getObject(i);
                    String objtype = "";
                    if (obj instanceof Struct) {
                        obj = new SerialStruct((Struct)obj, null);
                        objtype = "serialstruct";
                    } else if (obj instanceof SQLData) {
                        obj = new SerialStruct((SQLData)obj, null);
                        objtype = "sqldata";
                    } else if (obj instanceof Blob) {
                        obj = new SerialBlob((Blob)obj);
                        objtype = "blob";
                    } else if (obj instanceof Clob) {
                        obj = new SerialClob((Clob)obj);
                        objtype = "clob";
                    } else if (obj instanceof Array) {
                        obj = new SerialArray((Array)obj, null);
                        objtype = "array";
                    } else if (obj instanceof Integer) {
                        obj = new Integer((Integer)obj);
                        objtype = "integer";
                    } else if (obj instanceof Double) {
                        obj = new Double((Double)obj);
                        objtype = "double";
                    } else if (obj instanceof String) {
                        obj = new String((String)obj);
                        objtype = "string";
                    } else if (obj instanceof java.util.Date) {
                        objtype = "utildate";
                        java.util.Date dataobj = (java.util.Date)obj;
                        long millis = dataobj.getTime();
                        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss.SSS");
                    } else if (obj instanceof Date) {
                        objtype = "sqldte";
                    } else if (obj instanceof Time) {
                        objtype = "sqltime";
                    } else if (obj instanceof Timestamp) {
                        objtype = "sqltimestamp";
                    }
                    cols.add(obj);
                    ++countCol;
                    ++i;
                }
                rows.add(cols);
                ++countRow;
            }
        }
        catch (SerialException e) {
            logger.error((Object)"serial error populating", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"sqlexception populating", (Throwable)e);
        }
        return rows;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResultSetData)) {
            return false;
        }
        ResultSetData other = (ResultSetData)obj;
        return !(this.rows == null ? other.rows != null : !this.rows.equals(other.rows));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.rows != null) {
            for (ArrayList<Object> row : this.rows) {
                sb.append("[row:");
                for (Object col : row) {
                    sb.append(col).append(",");
                }
                sb.append("], [");
            }
        }
        sb.append("metadata: ");
        sb.append("]");
        return sb.toString();
    }
}

