/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import lasige.divdb.comm.Message;
import lasige.divdb.comm.MessageHandler;
import lasige.divdb.jdbc.BFTRowSet;

public class BFTStatement
implements Statement {
    private MessageHandler mHandler;
    private ResultSet generatedKeys;
    private Connection connection;

    public BFTStatement(MessageHandler mHandler, Connection connection) {
        this.mHandler = mHandler;
        this.connection = connection;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Message m = new Message(200, sql, true);
        Message reply = this.mHandler.send(m, this.getConnection().getAutoCommit());
        if (reply.getOpcode() == 202) {
            throw new SQLException("Error executing sql");
        }
        if (reply.getOpcode() == 93) {
            throw new SQLException("Timeout during execution");
        }
        if (reply.getOpcode() == 94) {
            throw new SQLException("Transaction aborted");
        }
        return (Integer)reply.getContents() == 1;
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        Message m = new Message(220, query, true);
        Message reply = null;
        reply = this.getConnection().getAutoCommit() ? this.mHandler.send(m, true) : this.mHandler.send(m, false);
        ResultSet rs = (ResultSet)reply.getContents();
        return rs;
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        Message m = new Message(220, query, true);
        Message reply = null;
        reply = this.getConnection().getAutoCommit() ? this.mHandler.send(m, false) : this.mHandler.send(m, true);
        int result = -1;
        if (reply.getContents() instanceof List) {
            List replyList = (List)reply.getContents();
            result = (Integer)replyList.get(0);
            this.setGeneratedKeys((BFTRowSet)replyList.get(1));
            result = 1;
        } else {
            result = (Integer)reply.getContents();
        }
        return result;
    }

    @Override
    public void setFetchSize(int val) throws SQLException {
        Message m = new Message(500, val, false);
        this.mHandler.send(m, this.getConnection().getAutoCommit());
    }

    @Override
    public void setMaxRows(int val) throws SQLException {
        Message m = new Message(501, val, false);
        this.mHandler.send(m, this.getConnection().getAutoCommit());
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setGeneratedKeys(ResultSet generatedKeys) {
        this.generatedKeys = generatedKeys;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.generatedKeys;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

