/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.jdbc;

import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.BaseRow;
import com.sun.rowset.internal.CachedRowSetReader;
import com.sun.rowset.internal.CachedRowSetWriter;
import com.sun.rowset.internal.InsertRow;
import com.sun.rowset.internal.Row;
import com.sun.rowset.providers.RIOptimisticProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SQLInputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;
import lasige.divdb.jdbc.BFTRow;
import lasige.divdb.jdbc.ResultSetData;
import org.apache.commons.lang.StringUtils;

public class BFTRowSet
extends CachedRowSetImpl
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    static final long serialVersionUID = 1884577171200622428L;
    private SyncProvider provider;
    private RowSetReader rowSetReader;
    private RowSetWriter rowSetWriter;
    private transient Connection conn;
    private RowSetMetaData RowSetMD;
    private int[] keyCols;
    private String tableName;
    private Vector<BaseRow> rvh;
    private int cursorPos;
    private int absolutePos;
    private int numDeleted;
    private int numRows;
    private InsertRow insertRow;
    private boolean onInsertRow;
    private int currentRow;
    private boolean lastValueNull;
    private SQLWarning sqlwarn;
    private RowSetWarning rowsetWarning;
    private String DEFAULT_SYNC_PROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private boolean dbmslocatorsUpdateCopy;
    private int endPos;
    private int prevEndPos;
    private int startPos;
    private int startPrev;
    private int pageSize;
    private int maxRowsreached;
    private boolean pagenotend = true;
    private boolean onFirstPage;
    private int populatecallcount;
    private int totalRows;
    private boolean callWithCon;
    private CachedRowSetReader crsReader;
    private Vector<Integer> iMatchColumns;
    private Vector<String> strMatchColumns;
    private boolean tXWriter = false;
    private TransactionalWriter tWriter = null;
    protected transient JdbcRowSetResourceBundle resBundle;
    private boolean updateOnInsert;

    public BFTRowSet() throws SQLException {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.provider = SyncFactory.getInstance(this.DEFAULT_SYNC_PROVIDER);
        if (!(this.provider instanceof RIOptimisticProvider)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidp").toString());
        }
        this.rowSetReader = (CachedRowSetReader)this.provider.getRowSetReader();
        this.rowSetWriter = (CachedRowSetWriter)this.provider.getRowSetWriter();
        this.initParams();
        this.initContainer();
        this.initProperties();
        this.onInsertRow = false;
        this.insertRow = null;
        this.sqlwarn = new SQLWarning();
        this.rowsetWarning = new RowSetWarning();
    }

    public void loadResourceBundle() {
        if (this.resBundle == null) {
            try {
                this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public BFTRowSet(Hashtable<String, String> env) throws SQLException {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (env == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.nullhash").toString());
        }
        String providerName = env.get("rowset.provider.classname");
        this.provider = SyncFactory.getInstance(providerName);
        this.rowSetReader = this.provider.getRowSetReader();
        this.rowSetWriter = this.provider.getRowSetWriter();
        this.initParams();
        this.initContainer();
        this.initProperties();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rvh == null ? 0 : this.rvh.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BFTRowSet)) {
            return false;
        }
        BFTRowSet other = (BFTRowSet)obj;
        return !(this.rvh == null ? other.rvh != null : !this.rvh.equals(other.rvh));
    }

    private void initContainer() {
        this.rvh = new Vector(100);
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
    }

    private void initProperties() throws SQLException {
        if (this.resBundle == null) {
            try {
                this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setType(1004);
        this.setConcurrency(1008);
        if (this.rvh.size() > 0 && !this.isReadOnly()) {
            this.setReadOnly(false);
        } else {
            this.setReadOnly(true);
        }
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.checkTransactionalWriter();
        this.iMatchColumns = new Vector(10);
        int i = 0;
        while (i < 10) {
            this.iMatchColumns.add(i, new Integer(-1));
            ++i;
        }
        this.strMatchColumns = new Vector(10);
        int j = 0;
        while (j < 10) {
            this.strMatchColumns.add(j, null);
            ++j;
        }
    }

    private void checkTransactionalWriter() {
        Class<?> c;
        if (this.rowSetWriter != null && (c = this.rowSetWriter.getClass()) != null) {
            Class<?>[] theInterfaces = c.getInterfaces();
            int i = 0;
            while (i < theInterfaces.length) {
                if (theInterfaces[i].getName().indexOf("TransactionalWriter") > 0) {
                    this.tXWriter = true;
                    this.establishTransactionalWriter();
                }
                ++i;
            }
        }
    }

    private void establishTransactionalWriter() {
        this.tWriter = (TransactionalWriter)this.provider.getRowSetWriter();
    }

    @Override
    public void setCommand(String cmd) throws SQLException {
        super.setCommand(cmd);
        if (!this.buildTableName(cmd).equals("")) {
            this.setTableName(this.buildTableName(cmd));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.rvh != null) {
            for (BaseRow row : this.rvh) {
                Object[] columns;
                sb.append("Class: ").append(row.getClass()).append(",");
                Object[] objectArray = columns = row.getOrigRow();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    Object column = objectArray[n2];
                    sb.append(column).append(",");
                    ++n2;
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void populate(ResultSetData data) throws SQLException {
        Map<String, Class<?>> map = this.getTypeMap();
        if (data == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.populate").toString());
        }
        this.RowSetMD = data.getMetadata();
        int numCols = this.RowSetMD.getColumnCount();
        int mRows = this.getMaxRows();
        int rowsFetched = 0;
        BFTRow currentRow = null;
        this.updateOnInsert = data.isUpdateOnInsert();
        for (List list : data.getRows()) {
            int i = 1;
            currentRow = new BFTRow(numCols);
            for (Object col : list) {
                currentRow.initColumnObject(i, col);
                ++i;
            }
            ++rowsFetched;
            this.rvh.add(currentRow);
        }
        this.numRows = rowsFetched;
        this.notifyRowSetChanged();
    }

    private void initMetaData(RowSetMetaDataImpl md, ResultSetMetaData rsmd) throws SQLException {
        int numCols = rsmd.getColumnCount();
        md.setColumnCount(numCols);
        int col = 1;
        while (col <= numCols) {
            md.setAutoIncrement(col, rsmd.isAutoIncrement(col));
            if (rsmd.isAutoIncrement(col)) {
                this.updateOnInsert = true;
            }
            md.setCaseSensitive(col, false);
            md.setCurrency(col, false);
            md.setNullable(col, rsmd.isNullable(col));
            md.setSigned(col, rsmd.isSigned(col));
            md.setSearchable(col, false);
            int size = rsmd.getColumnDisplaySize(col);
            if (size < 0) {
                size = 0;
            }
            md.setColumnDisplaySize(col, 0);
            if (StringUtils.isNotBlank((String)rsmd.getColumnLabel(col))) {
                md.setColumnLabel(col, rsmd.getColumnLabel(col).toLowerCase());
            }
            if (StringUtils.isNotBlank((String)rsmd.getColumnName(col))) {
                md.setColumnName(col, rsmd.getColumnName(col).toLowerCase());
            }
            md.setSchemaName(col, null);
            int precision = rsmd.getPrecision(col);
            if (precision < 0) {
                precision = 0;
            }
            md.setPrecision(col, 0);
            int scale = rsmd.getScale(col);
            if (scale < 0) {
                scale = 0;
            }
            md.setScale(col, 0);
            md.setTableName(col, null);
            md.setCatalogName(col, null);
            md.setColumnType(col, -1);
            md.setColumnTypeName(col, null);
            ++col;
        }
        if (this.conn != null) {
            this.dbmslocatorsUpdateCopy = this.conn.getMetaData().locatorsUpdateCopy();
        }
    }

    @Override
    public void execute(Connection conn) throws SQLException {
        this.setConnection(conn);
        if (this.getPageSize() != 0) {
            this.crsReader = (CachedRowSetReader)this.provider.getRowSetReader();
            this.crsReader.setStartPosition(1);
            this.callWithCon = true;
            this.crsReader.readData(this);
        } else {
            this.rowSetReader.readData(this);
        }
        this.RowSetMD = (RowSetMetaDataImpl)this.getMetaData();
        if (conn != null) {
            this.dbmslocatorsUpdateCopy = conn.getMetaData().locatorsUpdateCopy();
        }
    }

    private void setConnection(Connection connection) {
        this.conn = connection;
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        if (this.onInsertRow) {
            throw new SyncProviderException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        int saveCursorPos = this.cursorPos;
        boolean success = false;
        boolean conflict = false;
        try {
            if (this.rowSetWriter != null) {
                saveCursorPos = this.cursorPos;
                conflict = this.rowSetWriter.writeData(this);
                this.cursorPos = saveCursorPos;
            }
            if (this.tXWriter) {
                if (!conflict) {
                    this.tWriter = (TransactionalWriter)this.rowSetWriter;
                    this.tWriter.rollback();
                    success = false;
                } else {
                    this.tWriter = (TransactionalWriter)this.rowSetWriter;
                    ((CachedRowSetWriter)this.tWriter).commit(this, this.updateOnInsert);
                    success = true;
                }
            }
            if (success) {
                this.setOriginal();
            } else if (!success) {
                // empty if block
            }
        }
        catch (SyncProviderException spe) {
            throw spe;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SyncProviderException(e.getMessage());
        }
        catch (SecurityException e) {
            throw new SyncProviderException(e.getMessage());
        }
    }

    @Override
    public void acceptChanges(Connection con) throws SyncProviderException {
        this.setConnection(con);
        this.acceptChanges();
    }

    @Override
    public void restoreOriginal() throws SQLException {
        Iterator<BaseRow> i = this.rvh.iterator();
        while (i.hasNext()) {
            Row currentRow = (Row)i.next();
            if (currentRow.getInserted()) {
                i.remove();
                --this.numRows;
                continue;
            }
            if (currentRow.getDeleted()) {
                currentRow.clearDeleted();
            }
            if (!currentRow.getUpdated()) continue;
            currentRow.clearUpdated();
        }
        this.cursorPos = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public void release() throws SQLException {
        this.initContainer();
        this.notifyRowSetChanged();
    }

    @Override
    public void undoDelete() throws SQLException {
        if (!this.getShowDeleted()) {
            return;
        }
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row currentRow = (Row)this.getCurrentRow();
        if (currentRow.getDeleted()) {
            currentRow.clearDeleted();
            --this.numDeleted;
            this.notifyRowChanged();
        }
    }

    @Override
    public void undoInsert() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row currentRow = (Row)this.getCurrentRow();
        if (currentRow.getInserted()) {
            this.rvh.remove(this.cursorPos - 1);
            --this.numRows;
        } else {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.illegalop").toString());
        }
        this.notifyRowChanged();
    }

    @Override
    public void undoUpdate() throws SQLException {
        this.moveToCurrentRow();
        this.undoDelete();
        this.undoInsert();
    }

    @Override
    public RowSet createShared() throws SQLException {
        RowSet clone;
        try {
            clone = (RowSet)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new SQLException(ex.getMessage());
        }
        return clone;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        ObjectInputStream in;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bOut);
            out.writeObject(this);
        }
        catch (IOException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString(), ex.getMessage()));
        }
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            in = new ObjectInputStream(bIn);
        }
        catch (StreamCorruptedException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString(), ex.getMessage()));
        }
        catch (IOException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString(), ex.getMessage()));
        }
        try {
            BFTRowSet crsTemp = (BFTRowSet)in.readObject();
            crsTemp.resBundle = this.resBundle;
            return crsTemp;
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString(), ex.getMessage()));
        }
        catch (OptionalDataException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString(), ex.getMessage()));
        }
        catch (IOException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString(), ex.getMessage()));
        }
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        int nRows = this.numRows;
        this.numRows = 0;
        CachedRowSet crs = this.createCopy();
        this.numRows = nRows;
        return crs;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        BFTRowSet crs = (BFTRowSet)this.createCopy();
        crs.initProperties();
        try {
            crs.unsetMatchColumn(crs.getMatchColumnIndexes());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            crs.unsetMatchColumn(crs.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return crs;
    }

    @Override
    public Collection<?> toCollection() throws SQLException {
        TreeMap<Integer, BaseRow> tMap = new TreeMap<Integer, BaseRow>();
        int i = 0;
        while (i < this.numRows) {
            tMap.put(new Integer(i), this.rvh.get(i));
            ++i;
        }
        return tMap.values();
    }

    @Override
    public Collection<?> toCollection(int column) throws SQLException {
        int nRows = this.numRows;
        Vector<Object> vec = new Vector<Object>(nRows);
        BFTRowSet crsTemp = (BFTRowSet)this.createCopy();
        while (nRows != 0) {
            crsTemp.next();
            vec.add(crsTemp.getObject(column));
            --nRows;
        }
        return vec;
    }

    @Override
    public Collection<?> toCollection(String column) throws SQLException {
        return this.toCollection(this.getColIdxByName(column));
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.provider;
    }

    @Override
    public void setSyncProvider(String providerStr) throws SQLException {
        this.provider = SyncFactory.getInstance(providerStr);
        this.rowSetReader = this.provider.getRowSetReader();
        this.rowSetWriter = this.provider.getRowSetWriter();
    }

    @Override
    public void execute() throws SQLException {
        this.execute(null);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.cursorPos < 0 || this.cursorPos >= this.numRows + 1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        boolean ret = this.internalNext();
        this.notifyCursorMoved();
        return ret;
    }

    @Override
    protected boolean internalNext() throws SQLException {
        boolean ret = false;
        do {
            if (this.cursorPos < this.numRows) {
                ++this.cursorPos;
                ret = true;
                continue;
            }
            if (this.cursorPos != this.numRows) continue;
            ++this.cursorPos;
            ret = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = ret ? ++this.absolutePos : 0;
        return ret;
    }

    @Override
    public void close() throws SQLException {
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
        this.initProperties();
        this.rvh.clear();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueNull;
    }

    private void setLastValueNull(boolean value) {
        this.lastValueNull = value;
    }

    private void checkIndex(int idx) throws SQLException {
        if (idx < 1 || idx > this.RowSetMD.getColumnCount()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcol").toString());
        }
    }

    private void checkCursor() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
    }

    private int getColIdxByName(String name) throws SQLException {
        this.RowSetMD = (RowSetMetaDataImpl)this.getMetaData();
        int cols = this.RowSetMD.getColumnCount();
        int i = 1;
        while (i <= cols) {
            String colName = this.RowSetMD.getColumnName(i);
            String colLabel = this.RowSetMD.getColumnLabel(i);
            if ((colName != null || colLabel != null) && (name.equalsIgnoreCase(colName) || name.equalsIgnoreCase(colLabel))) {
                return i;
            }
            ++i;
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalcolnm").toString());
    }

    @Override
    protected BaseRow getCurrentRow() {
        if (this.onInsertRow) {
            return this.insertRow;
        }
        return this.rvh.get(this.cursorPos - 1);
    }

    @Override
    protected void removeCurrentRow() {
        ((Row)this.getCurrentRow()).setDeleted();
        this.rvh.remove(this.cursorPos);
        --this.numRows;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            Double d = new Double(value.toString());
            return d.compareTo(new Double(0.0)) != 0;
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.boolfail").toString(), value.toString().trim(), columnIndex));
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Byte(value.toString());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.bytefail").toString(), value.toString().trim(), columnIndex));
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Short(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.shortfail").toString(), value.toString().trim(), columnIndex));
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Integer(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.intfail").toString(), value.toString().trim(), columnIndex));
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0L;
        }
        try {
            return new Long(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.longfail").toString(), value.toString().trim(), columnIndex));
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0.0f;
        }
        try {
            return new Float(value.toString()).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.floatfail").toString(), value.toString().trim(), columnIndex));
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return 0.0;
        }
        try {
            return new Double(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.doublefail").toString(), value.toString().trim(), columnIndex));
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return new BigDecimal(0);
        }
        BigDecimal bDecimal = this.getBigDecimal(columnIndex);
        BigDecimal retVal = bDecimal.setScale(scale);
        return retVal;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        return (byte[])this.getCurrentRow().getColumnObject(columnIndex);
    }

    @Override
    public java.sql.Date getDate(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(columnIndex)) {
            case 91: {
                long sec = ((java.sql.Date)value).getTime();
                return new java.sql.Date(sec);
            }
            case 93: {
                long sec = ((Timestamp)value).getTime();
                return new java.sql.Date(sec);
            }
            case -1: 
            case 1: 
            case 12: {
                Date parsedDate = this.parseDate(columnIndex, value);
                return new java.sql.Date(parsedDate.getTime());
            }
        }
        throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.datefail").toString(), value.toString().trim(), columnIndex));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(columnIndex)) {
            case 92: {
                return (Time)value;
            }
            case 93: {
                long sec = ((Timestamp)value).getTime();
                return new Time(sec);
            }
            case -1: 
            case 1: 
            case 12: {
                Date parsedDate = this.parseDate(columnIndex, value);
                return new Time(parsedDate.getTime());
            }
        }
        throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString(), value.toString().trim(), columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(columnIndex)) {
            case 93: {
                return (Timestamp)value;
            }
            case 92: {
                long sec = ((Time)value).getTime();
                return new Timestamp(sec);
            }
            case 91: {
                long sec = ((java.sql.Date)value).getTime();
                return new Timestamp(sec);
            }
            case -1: 
            case 1: 
            case 12: {
                Date parsedDate = this.parseDate(columnIndex, value);
                return new Timestamp(parsedDate.getTime());
            }
        }
        throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString(), value.toString().trim(), columnIndex));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.asciiStream = null;
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.lastValueNull = true;
            return null;
        }
        try {
            if (!this.isString(this.RowSetMD.getColumnType(columnIndex))) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
            }
            this.asciiStream = new ByteArrayInputStream(((String)value).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException(ex.getMessage());
        }
        return this.asciiStream;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.binaryStream = null;
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.lastValueNull = true;
            return null;
        }
        this.binaryStream = new ByteArrayInputStream((byte[])value);
        return this.binaryStream;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.getColIdxByName(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.getColIdxByName(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.getColIdxByName(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.getColIdxByName(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.getColIdxByName(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.getColIdxByName(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.getColIdxByName(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.getColIdxByName(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.getColIdxByName(columnName));
    }

    @Override
    public java.sql.Date getDate(String columnName) throws SQLException {
        return this.getDate(this.getColIdxByName(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.getColIdxByName(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.getColIdxByName(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.getColIdxByName(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.getColIdxByName(columnName));
    }

    @Override
    public SQLWarning getWarnings() {
        return this.sqlwarn;
    }

    @Override
    public void clearWarnings() {
        this.sqlwarn = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.posupdate").toString());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.RowSetMD;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (value instanceof Struct) {
            Struct s = (Struct)value;
            Map<String, Class<?>> map = this.getTypeMap();
            Class<?> c = map.get(s.getSQLTypeName());
            if (c != null) {
                SQLData obj = null;
                try {
                    obj = (SQLData)c.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString(), ex.getMessage()));
                }
                catch (IllegalAccessException ex) {
                    throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString(), ex.getMessage()));
                }
                Object[] attribs = s.getAttributes(map);
                SQLInputImpl sqlInput = new SQLInputImpl(attribs, map);
                obj.readSQL(sqlInput, s.getSQLTypeName());
                return obj;
            }
        }
        return value;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.getColIdxByName(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.getColIdxByName(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.isBinary(this.RowSetMD.getColumnType(columnIndex))) {
            Object value = this.getCurrentRow().getColumnObject(columnIndex);
            if (value == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new InputStreamReader(new ByteArrayInputStream((byte[])value));
        } else if (this.isString(this.RowSetMD.getColumnType(columnIndex))) {
            Object value = this.getCurrentRow().getColumnObject(columnIndex);
            if (value == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new StringReader(value.toString());
        } else {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        return this.charStream;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.getColIdxByName(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return new BigDecimal(value.toString().trim());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.doublefail").toString(), value.toString().trim(), columnIndex));
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(columnName));
    }

    @Override
    public int size() {
        return this.numRows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        int saveCursorPos = this.cursorPos;
        int saveAbsoluteCursorPos = this.absolutePos;
        this.internalFirst();
        if (this.cursorPos == saveCursorPos) {
            return true;
        }
        this.cursorPos = saveCursorPos;
        this.absolutePos = saveAbsoluteCursorPos;
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        int saveCursorPos = this.cursorPos;
        int saveAbsoluteCursorPos = this.absolutePos;
        boolean saveShowDeleted = this.getShowDeleted();
        this.setShowDeleted(true);
        this.internalLast();
        if (this.cursorPos == saveCursorPos) {
            this.setShowDeleted(saveShowDeleted);
            return true;
        }
        this.setShowDeleted(saveShowDeleted);
        this.cursorPos = saveCursorPos;
        this.absolutePos = saveAbsoluteCursorPos;
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.beforefirst").toString());
        }
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.notifyCursorMoved();
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.numRows > 0) {
            this.cursorPos = this.numRows + 1;
            this.absolutePos = 0;
            this.notifyCursorMoved();
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.first").toString());
        }
        boolean ret = this.internalFirst();
        this.notifyCursorMoved();
        return ret;
    }

    @Override
    protected boolean internalFirst() throws SQLException {
        boolean ret = false;
        if (this.numRows > 0) {
            this.cursorPos = 1;
            ret = !this.getShowDeleted() && this.rowDeleted() ? this.internalNext() : true;
        }
        this.absolutePos = ret ? 1 : 0;
        return ret;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.last").toString());
        }
        boolean ret = this.internalLast();
        this.notifyCursorMoved();
        return ret;
    }

    @Override
    protected boolean internalLast() throws SQLException {
        boolean ret = false;
        if (this.numRows > 0) {
            this.cursorPos = this.numRows;
            ret = !this.getShowDeleted() && this.rowDeleted() ? this.internalPrevious() : true;
        }
        this.absolutePos = ret ? this.numRows - this.numDeleted : 0;
        return ret;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.numRows > 0 && this.cursorPos > 0 && this.cursorPos < this.numRows + 1 && !this.getShowDeleted() && !this.rowDeleted()) {
            return this.absolutePos;
        }
        if (this.getShowDeleted()) {
            return this.cursorPos;
        }
        return 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row == 0 || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.absolute").toString());
        }
        if (row > 0) {
            if (row > this.numRows) {
                this.afterLast();
                return false;
            }
            if (this.absolutePos <= 0) {
                this.internalFirst();
            }
        } else {
            if (this.cursorPos + row < 0) {
                this.beforeFirst();
                return false;
            }
            if (this.absolutePos >= 0) {
                this.internalLast();
            }
        }
        while (this.absolutePos != row) {
            if (this.absolutePos >= row ? !this.internalPrevious() : !this.internalNext()) break;
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.numRows == 0 || this.isBeforeFirst() || this.isAfterLast() || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.relative").toString());
        }
        if (rows == 0) {
            return true;
        }
        if (rows > 0) {
            if (this.cursorPos + rows > this.numRows) {
                this.afterLast();
            } else {
                int i = 0;
                while (i < rows) {
                    if (this.internalNext()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.cursorPos + rows < 0) {
            this.beforeFirst();
        } else {
            int i = rows;
            while (i < 0) {
                if (this.internalPrevious()) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.last").toString());
        }
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        boolean ret = this.internalPrevious();
        this.notifyCursorMoved();
        return ret;
    }

    @Override
    protected boolean internalPrevious() throws SQLException {
        boolean ret = false;
        do {
            if (this.cursorPos > 1) {
                --this.cursorPos;
                ret = true;
                continue;
            }
            if (this.cursorPos != 1) continue;
            --this.cursorPos;
            ret = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = ret ? --this.absolutePos : 0;
        return ret;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getUpdated();
    }

    @Override
    public boolean columnUpdated(int idx) throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getColUpdated(idx - 1);
    }

    @Override
    public boolean columnUpdated(String columnName) throws SQLException {
        return this.columnUpdated(this.getColIdxByName(columnName));
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst() || this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        return ((Row)this.getCurrentRow()).getDeleted();
    }

    private boolean isNumeric(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isString(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isBinary(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporal(int type) {
        switch (type) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private boolean isBoolean(int type) {
        switch (type) {
            case -7: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private Object convertNumeric(Object srcObj, int srcType, int trgType) throws SQLException {
        if (srcType == trgType) {
            return srcObj;
        }
        if (!this.isNumeric(trgType) && !this.isString(trgType)) {
            throw new SQLException(String.valueOf(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString()) + trgType);
        }
        try {
            switch (trgType) {
                case -7: {
                    Integer i = new Integer(srcObj.toString().trim());
                    return i.equals(new Integer(0)) ? new Boolean(false) : new Boolean(true);
                }
                case -6: {
                    return new Byte(srcObj.toString().trim());
                }
                case 5: {
                    return new Short(srcObj.toString().trim());
                }
                case 4: {
                    return new Integer(srcObj.toString().trim());
                }
                case -5: {
                    return new Long(srcObj.toString().trim());
                }
                case 2: 
                case 3: {
                    return new BigDecimal(srcObj.toString().trim());
                }
                case 6: 
                case 7: {
                    return new Float(srcObj.toString().trim());
                }
                case 8: {
                    return new Double(srcObj.toString().trim());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(srcObj.toString());
                }
            }
            throw new SQLException(String.valueOf(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString()) + trgType);
        }
        catch (NumberFormatException ex) {
            throw new SQLException(String.valueOf(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString()) + trgType);
        }
    }

    private Object convertTemporal(Object srcObj, int srcType, int trgType) throws SQLException {
        if (srcType == trgType) {
            return srcObj;
        }
        if (this.isNumeric(trgType) || !this.isString(trgType) && !this.isTemporal(trgType)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        try {
            switch (trgType) {
                case 91: {
                    if (srcType == 93) {
                        return new java.sql.Date(((Timestamp)srcObj).getTime());
                    }
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
                }
                case 93: {
                    if (srcType == 92) {
                        return new Timestamp(((Time)srcObj).getTime());
                    }
                    return new Timestamp(((java.sql.Date)srcObj).getTime());
                }
                case 92: {
                    if (srcType == 93) {
                        return new Time(((Timestamp)srcObj).getTime());
                    }
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(srcObj.toString());
                }
            }
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        catch (NumberFormatException ex) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
    }

    private Object convertBoolean(Object srcObj, int srcType, int trgType) throws SQLException {
        if (srcType == trgType) {
            return srcObj;
        }
        if (this.isNumeric(trgType) || !this.isString(trgType) && !this.isBoolean(trgType)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        try {
            switch (trgType) {
                case -7: {
                    Integer i = new Integer(srcObj.toString().trim());
                    return i.equals(new Integer(0)) ? new Boolean(false) : new Boolean(true);
                }
                case 16: {
                    return new Boolean(srcObj.toString().trim());
                }
            }
            throw new SQLException(String.valueOf(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString()) + trgType);
        }
        catch (NumberFormatException ex) {
            throw new SQLException(String.valueOf(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString()) + trgType);
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        BaseRow row = this.getCurrentRow();
        row.setColumnObject(columnIndex, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertBoolean(new Boolean(x), -7, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Byte(x), -6, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Short(x), 5, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Integer(x), 4, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Long(x), -5, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Float(x), 7, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(new Double(x), 8, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertNumeric(x, 2, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, java.sql.Date x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertTemporal(x, 91, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertTemporal(x, 92, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        Object obj = this.convertTemporal(x, 93, this.RowSetMD.getColumnType(columnIndex));
        this.getCurrentRow().setColumnObject(columnIndex, obj);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isString(this.RowSetMD.getColumnType(columnIndex)) && !this.isBinary(this.RowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        byte[] buf = new byte[length];
        try {
            int charsRead = 0;
            while ((charsRead += x.read(buf, charsRead, length - charsRead)) != length) {
            }
        }
        catch (IOException ex) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.asciistream").toString());
        }
        String str = new String(buf);
        this.getCurrentRow().setColumnObject(columnIndex, str);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        byte[] buf = new byte[length];
        try {
            int bytesRead = 0;
            while ((bytesRead += x.read(buf, bytesRead, length - bytesRead)) != -1) {
            }
        }
        catch (IOException ex) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.binstream").toString());
        }
        this.getCurrentRow().setColumnObject(columnIndex, buf);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.isString(this.RowSetMD.getColumnType(columnIndex)) && !this.isBinary(this.RowSetMD.getColumnType(columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        char[] buf = new char[length];
        try {
            int charsRead = 0;
            while ((charsRead += x.read(buf, charsRead, length - charsRead)) != length) {
            }
        }
        catch (IOException ex) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.binstream").toString());
        }
        String str = new String(buf);
        this.getCurrentRow().setColumnObject(columnIndex, str);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        int type = this.RowSetMD.getColumnType(columnIndex);
        if (type == 3 || type == 2) {
            ((BigDecimal)x).setScale(scale);
        }
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.getColIdxByName(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateDate(String columnName, java.sql.Date x) throws SQLException {
        this.updateDate(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.getColIdxByName(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.getColIdxByName(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.getColIdxByName(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.getColIdxByName(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.getColIdxByName(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.getColIdxByName(columnName), x);
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.onInsertRow || !this.insertRow.isCompleteRow(this.RowSetMD)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.failedins").toString());
        }
        Object[] toInsert = this.getParams();
        int i = 0;
        while (i < toInsert.length) {
            this.insertRow.setColumnObject(i + 1, toInsert[i]);
            ++i;
        }
        Row insRow = new Row(this.RowSetMD.getColumnCount(), this.insertRow.getOrigRow());
        insRow.setInserted();
        int pos = this.currentRow >= this.numRows || this.currentRow < 0 ? this.numRows : this.currentRow;
        this.rvh.add(pos, insRow);
        ++this.numRows;
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.updateins").toString());
        }
        ((Row)this.getCurrentRow()).setUpdated();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkCursor();
        ((Row)this.getCurrentRow()).setDeleted();
        ++this.numDeleted;
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row currentRow = (Row)this.getCurrentRow();
        currentRow.clearUpdated();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row currentRow = (Row)this.getCurrentRow();
        if (currentRow.getUpdated()) {
            currentRow.clearUpdated();
            this.notifyRowChanged();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.getConcurrency() == 1007) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins").toString());
        }
        if (this.insertRow == null) {
            if (this.RowSetMD == null) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins1").toString());
            }
            int numCols = this.RowSetMD.getColumnCount();
            if (numCols > 0) {
                this.insertRow = new InsertRow(numCols);
            } else {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins2").toString());
            }
        }
        this.onInsertRow = true;
        this.currentRow = this.cursorPos;
        this.cursorPos = -1;
        this.insertRow.initInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (!this.onInsertRow) {
            return;
        }
        this.cursorPos = this.currentRow;
        this.onInsertRow = false;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        Struct s;
        Class<?> c;
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (value instanceof Struct && (c = map.get((s = (Struct)value).getSQLTypeName())) != null) {
            SQLData obj = null;
            try {
                obj = (SQLData)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString(), ex.getMessage()));
            }
            catch (IllegalAccessException ex) {
                throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString(), ex.getMessage()));
            }
            Object[] attribs = s.getAttributes(map);
            SQLInputImpl sqlInput = new SQLInputImpl(attribs, map);
            obj.readSQL(sqlInput, s.getSQLTypeName());
            return obj;
        }
        return value;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(columnIndex) != 2006) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Ref value = (Ref)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(columnIndex) != 2004) {
            System.out.println(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.type").toString(), this.RowSetMD.getColumnType(columnIndex)));
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Blob value = (Blob)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(columnIndex) != 2005) {
            System.out.println(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.type").toString(), this.RowSetMD.getColumnType(columnIndex)));
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Clob value = (Clob)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(columnIndex) != 2003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Array value = (Array)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.getColIdxByName(columnName), map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.getColIdxByName(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.getColIdxByName(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.getColIdxByName(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.getColIdxByName(colName));
    }

    @Override
    public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        value = this.convertTemporal(value, this.RowSetMD.getColumnType(columnIndex), 91);
        Calendar defaultCal = Calendar.getInstance();
        defaultCal.setTime((Date)value);
        cal.set(1, defaultCal.get(1));
        cal.set(2, defaultCal.get(2));
        cal.set(5, defaultCal.get(5));
        return new java.sql.Date(cal.getTime().getTime());
    }

    @Override
    public java.sql.Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.getColIdxByName(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        value = this.convertTemporal(value, this.RowSetMD.getColumnType(columnIndex), 92);
        Calendar defaultCal = Calendar.getInstance();
        defaultCal.setTime((Date)value);
        cal.set(11, defaultCal.get(11));
        cal.set(12, defaultCal.get(12));
        cal.set(13, defaultCal.get(13));
        return new Time(cal.getTime().getTime());
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.getColIdxByName(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.setLastValueNull(false);
        Object value = this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        value = this.convertTemporal(value, this.RowSetMD.getColumnType(columnIndex), 93);
        Calendar defaultCal = Calendar.getInstance();
        defaultCal.setTime((Date)value);
        cal.set(1, defaultCal.get(1));
        cal.set(2, defaultCal.get(2));
        cal.set(5, defaultCal.get(5));
        cal.set(11, defaultCal.get(11));
        cal.set(12, defaultCal.get(12));
        cal.set(13, defaultCal.get(13));
        return new Timestamp(cal.getTime().getTime());
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(columnName), cal);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void setMetaData(RowSetMetaData md) throws SQLException {
        this.RowSetMD = (RowSetMetaDataImpl)md;
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        BFTRowSet crs = new BFTRowSet();
        crs.RowSetMD = this.RowSetMD;
        crs.numRows = this.numRows;
        crs.cursorPos = 0;
        int colCount = this.RowSetMD.getColumnCount();
        Iterator<BaseRow> i = this.rvh.iterator();
        while (i.hasNext()) {
            Row orig = new Row(colCount, i.next().getOrigRow());
            crs.rvh.add(orig);
        }
        return crs;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        BFTRowSet crs = new BFTRowSet();
        crs.RowSetMD = this.RowSetMD;
        crs.numRows = 1;
        crs.cursorPos = 0;
        Row orig = new Row(this.RowSetMD.getColumnCount(), this.getCurrentRow().getOrigRow());
        crs.rvh.add(orig);
        return crs;
    }

    @Override
    public void setOriginalRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        Row row = (Row)this.getCurrentRow();
        this.makeRowOriginal(row);
        if (row.getDeleted()) {
            this.removeCurrentRow();
            --this.numRows;
        }
    }

    private void makeRowOriginal(Row row) {
        if (row.getInserted()) {
            row.clearInserted();
        }
        if (row.getUpdated()) {
            row.moveCurrentToOrig();
        }
    }

    @Override
    public void setOriginal() throws SQLException {
        Iterator<BaseRow> i = this.rvh.iterator();
        while (i.hasNext()) {
            Row row = (Row)i.next();
            this.makeRowOriginal(row);
            if (!row.getDeleted()) continue;
            i.remove();
            --this.numRows;
        }
        this.numDeleted = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public String getTableName() throws SQLException {
        return this.tableName;
    }

    @Override
    public void setTableName(String tabName) throws SQLException {
        if (tabName == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.tablename").toString());
        }
        this.tableName = new String(tabName);
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.keyCols;
    }

    @Override
    public void setKeyColumns(int[] keys) throws SQLException {
        int numCols = 0;
        if (this.RowSetMD != null && keys.length > (numCols = this.RowSetMD.getColumnCount())) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.keycols").toString());
        }
        this.keyCols = new int[keys.length];
        int i = 0;
        while (i < keys.length) {
            if (this.RowSetMD != null && (keys[i] <= 0 || keys[i] > numCols)) {
                throw new SQLException(String.valueOf(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcol").toString()) + keys[i]);
            }
            this.keyCols[i] = keys[i];
            ++i;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(columnIndex, new SerialRef(ref));
    }

    @Override
    public void updateRef(String columnName, Ref ref) throws SQLException {
        this.updateRef(this.getColIdxByName(columnName), ref);
    }

    @Override
    public void updateClob(int columnIndex, Clob c) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.dbmslocatorsUpdateCopy) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotsupp").toString());
        }
        this.getCurrentRow().setColumnObject(columnIndex, new SerialClob(c));
    }

    @Override
    public void updateClob(String columnName, Clob c) throws SQLException {
        this.updateClob(this.getColIdxByName(columnName), c);
    }

    @Override
    public void updateBlob(int columnIndex, Blob b) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (!this.dbmslocatorsUpdateCopy) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotsupp").toString());
        }
        this.getCurrentRow().setColumnObject(columnIndex, new SerialBlob(b));
    }

    @Override
    public void updateBlob(String columnName, Blob b) throws SQLException {
        this.updateBlob(this.getColIdxByName(columnName), b);
    }

    @Override
    public void updateArray(int columnIndex, Array a) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(columnIndex, new SerialArray(a));
    }

    @Override
    public void updateArray(String columnName, Array a) throws SQLException {
        this.updateArray(this.getColIdxByName(columnName), a);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(columnIndex) != 70) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        URL value = (URL)this.getCurrentRow().getColumnObject(columnIndex);
        if (value == null) {
            this.setLastValueNull(true);
            return null;
        }
        return value;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.getColIdxByName(columnName));
    }

    @Override
    public RowSetWarning getRowSetWarnings() {
        try {
            this.notifyCursorMoved();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.rowsetWarning;
    }

    private String buildTableName(String command) throws SQLException {
        String strTablename = "";
        if ((command = command.trim()).toLowerCase().startsWith("select")) {
            int indexFrom = command.toLowerCase().indexOf("from");
            int indexComma = command.indexOf(",", indexFrom);
            if (indexComma == -1) {
                strTablename = command.substring(indexFrom + "from".length(), command.length()).trim();
                String tabName = strTablename;
                int idxWhere = tabName.toLowerCase().indexOf("where");
                if (idxWhere != -1) {
                    tabName = tabName.substring(0, idxWhere).trim();
                }
                strTablename = tabName;
            }
        } else if (!command.toLowerCase().startsWith("insert")) {
            command.toLowerCase().startsWith("update");
        }
        return strTablename;
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint s) throws SQLException {
        this.conn.rollback(s);
    }

    @Override
    public void unsetMatchColumn(int[] columnIdxes) throws SQLException {
        int j = 0;
        while (j < columnIdxes.length) {
            int i_val = Integer.parseInt(this.iMatchColumns.get(j).toString());
            if (columnIdxes[j] != i_val) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols").toString());
            }
            ++j;
        }
        int i = 0;
        while (i < columnIdxes.length) {
            this.iMatchColumns.set(i, new Integer(-1));
            ++i;
        }
    }

    @Override
    public void unsetMatchColumn(String[] columnIdxes) throws SQLException {
        int j = 0;
        while (j < columnIdxes.length) {
            if (!columnIdxes[j].equals(this.strMatchColumns.get(j))) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols").toString());
            }
            ++j;
        }
        int i = 0;
        while (i < columnIdxes.length) {
            this.strMatchColumns.set(i, null);
            ++i;
        }
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        Object[] str_temp = new String[this.strMatchColumns.size()];
        if (this.strMatchColumns.get(0) == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.setmatchcols").toString());
        }
        this.strMatchColumns.copyInto(str_temp);
        return str_temp;
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        Object[] int_temp = new Integer[this.iMatchColumns.size()];
        int[] i_temp = new int[this.iMatchColumns.size()];
        int i_val = this.iMatchColumns.get(0);
        if (i_val == -1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.setmatchcols").toString());
        }
        this.iMatchColumns.copyInto(int_temp);
        int i = 0;
        while (i < int_temp.length) {
            i_temp[i] = (Integer)int_temp[i];
            ++i;
        }
        return i_temp;
    }

    @Override
    public void setMatchColumn(int[] columnIdxes) throws SQLException {
        int j = 0;
        while (j < columnIdxes.length) {
            if (columnIdxes[j] < 0) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols1").toString());
            }
            ++j;
        }
        int i = 0;
        while (i < columnIdxes.length) {
            this.iMatchColumns.add(i, new Integer(columnIdxes[i]));
            ++i;
        }
    }

    @Override
    public void setMatchColumn(String[] columnNames) throws SQLException {
        int j = 0;
        while (j < columnNames.length) {
            if (columnNames[j] == null || columnNames[j].equals("")) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols2").toString());
            }
            ++j;
        }
        int i = 0;
        while (i < columnNames.length) {
            this.strMatchColumns.add(i, columnNames[i]);
            ++i;
        }
    }

    @Override
    public void setMatchColumn(int columnIdx) throws SQLException {
        if (columnIdx < 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols1").toString());
        }
        this.iMatchColumns.set(0, new Integer(columnIdx));
    }

    @Override
    public void setMatchColumn(String columnName) throws SQLException {
        if (columnName.equals(null) || (columnName = columnName.trim()) == "") {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols2").toString());
        }
        this.strMatchColumns.set(0, columnName);
    }

    @Override
    public void unsetMatchColumn(int columnIdx) throws SQLException {
        if (!this.iMatchColumns.get(0).equals(new Integer(columnIdx))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch").toString());
        }
        if (this.strMatchColumns.get(0) != null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch1").toString());
        }
        this.iMatchColumns.set(0, new Integer(-1));
    }

    @Override
    public void unsetMatchColumn(String columnName) throws SQLException {
        columnName = columnName.trim();
        if (!this.strMatchColumns.get(0).equals(columnName)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch").toString());
        }
        if (this.iMatchColumns.get(0) > 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch2").toString());
        }
        this.strMatchColumns.set(0, null);
    }

    @Override
    public void rowSetPopulated(RowSetEvent event, int numRows) throws SQLException {
        if (numRows < 0 || numRows < this.getFetchSize()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.numrows").toString());
        }
        if (this.size() % numRows == 0) {
            RowSetEvent event_temp;
            event = event_temp = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    @Override
    public void populate(ResultSet data, int start) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean nextPage() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPageSize(int size) throws SQLException {
        if (size < 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.pagesize").toString());
        }
        if (size > this.getMaxRows() && this.getMaxRows() != 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.pagesize1").toString());
        }
        this.pageSize = size;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean previousPage() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRowInserted(boolean insertFlag) throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        if (insertFlag) {
            ((Row)this.getCurrentRow()).setInserted();
        } else {
            ((Row)this.getCurrentRow()).clearInserted();
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public SQLXML getSQLXML(String colName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public NClob getNClob(String colName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        return false;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotysupp").toString());
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setDate(String parameterName, java.sql.Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setDate(String parameterName, java.sql.Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.resBundle.handleGetObject("cachedrowsetimpl.featnotsupp").toString());
    }

    protected void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private Date parseDate(int columnIndex, Object value) throws SQLException {
        try {
            SimpleDateFormat df = new SimpleDateFormat();
            String valueString = value.toString();
            int length = valueString.length();
            if (length == 10) {
                if (valueString.charAt(4) == '-') {
                    df = new SimpleDateFormat("yyyy-MM-dd");
                } else if (valueString.charAt(50) == '-') {
                    df = new SimpleDateFormat("dd-MM-yyyy");
                }
            } else if (length == 23) {
                if (valueString.charAt(4) == '-') {
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                }
            } else if (length == 22) {
                if (valueString.charAt(4) == '-') {
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
                }
            } else if (length == 21) {
                if (valueString.charAt(4) == '-') {
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                }
            } else if (length == 19) {
                if (valueString.charAt(4) == '-') {
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
            } else if (length == 8) {
                if (valueString.charAt(2) == ':') {
                    df = new SimpleDateFormat("HH:mm:ss");
                }
            } else if (length == 5 && valueString.charAt(2) == ':') {
                df = new SimpleDateFormat("HH:mm");
            }
            Date dateValue = df.parse(value.toString());
            return dateValue;
        }
        catch (ParseException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString(), value.toString().trim(), columnIndex));
        }
    }

    public byte[] getResultsBytes() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream obOut = null;
        try {
            obOut = new ObjectOutputStream(bOut);
            obOut.writeObject(this.rvh);
            obOut.flush();
            bOut.flush();
            obOut.close();
            bOut.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return bOut.toByteArray();
    }
}

