/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import lasige.divdb.comm.Message;
import lasige.divdb.comm.MessageHandler;

public class BFTPreparedStatement
implements PreparedStatement {
    private boolean closed;
    private MessageHandler mHandler;
    private HashMap<Integer, String> parameters = new HashMap();
    private String template;
    private String current;
    private LinkedList<String> batch = new LinkedList();
    private int statementOption;
    private ResultSet generatedKeys;
    private Connection connection;
    private int[] parameterTypes;
    private int parameterCount = -1;
    private int parameterIndexOffset = -1;
    protected int maxRows = -1;
    protected int timeoutInMillis = -1;

    public BFTPreparedStatement(Connection connection, MessageHandler mHandler, String sql) {
        this.connection = connection;
        this.mHandler = mHandler;
        this.parseSQL(sql.toLowerCase());
        this.template = sql.toLowerCase();
        this.current = sql.toLowerCase();
        this.closed = false;
        this.parameters = new HashMap();
    }

    public BFTPreparedStatement(Connection connection, MessageHandler mHandler, String sql, int statementOption) {
        this.connection = connection;
        this.mHandler = mHandler;
        this.parseSQL(sql.toLowerCase());
        this.template = sql.toLowerCase();
        this.current = sql.toLowerCase();
        this.closed = false;
        this.statementOption = statementOption;
        this.parameters = new HashMap();
    }

    private void parseSQL(String sql) {
        int index = 0;
        int count = 0;
        index = sql.indexOf(63);
        while (index > -1) {
            ++count;
            index = sql.indexOf(63, index + 1);
        }
        this.parameterCount = count;
        if (this.parameterCount > 0) {
            this.parameterTypes = new int[this.parameterCount];
        }
    }

    private Object process(int opcode) throws SQLException {
        if (this.closed) {
            throw new SQLException("Can't execute after statement has been closed");
        }
        if (this.current.contains("?")) {
            this.current = this.updateSql(this.current);
        }
        Message query = this.statementOption > 0 ? new Message(opcode, this.current, true, this.statementOption) : new Message(opcode, this.current, true);
        Message reply = null;
        reply = this.getConnection().getAutoCommit() ? this.mHandler.send(query, true) : this.mHandler.send(query, false);
        if (reply.getOpcode() == 222) {
            throw new SQLException("Execute query error");
        }
        if (reply.getOpcode() == 212) {
            throw new SQLException("Execute update error");
        }
        if (reply.getOpcode() == 93) {
            throw new SQLException("Execution timeout");
        }
        if (reply.getOpcode() == 94) {
            throw new SQLException("Transaction aborted");
        }
        if (query.getStatementOption() > 0) {
            this.generatedKeys = reply.getRowSet();
        }
        return reply.getContents();
    }

    private String updateSql(String sql) {
        StringBuffer newSql = new StringBuffer(sql);
        int paramLoc = 1;
        while (this.getCharIndexFromSqlByParamLocation(sql, '?', paramLoc) > 0) {
            if (this.parameters.containsKey(paramLoc)) {
                int tt = this.getCharIndexFromSqlByParamLocation(newSql.toString(), '?', 1);
                newSql.deleteCharAt(tt);
                newSql.insert(tt, this.parameters.get(paramLoc));
            }
            ++paramLoc;
        }
        return newSql.toString();
    }

    private int getCharIndexFromSqlByParamLocation(String sql, char cchar, int paramLoc) {
        int signalCount = 0;
        int charIndex = -1;
        int num = 0;
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (c == '\'' || c == '\\') {
                ++signalCount;
            } else if (c == cchar && signalCount % 2 == 0 && ++num == paramLoc) {
                charIndex = i;
                break;
            }
            ++i;
        }
        return charIndex;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Object o = this.process(220);
        ResultSet rs = (ResultSet)o;
        this.current = this.template;
        this.parameters.clear();
        return rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int result = (Integer)this.process(210);
        this.current = this.template;
        this.parameters.clear();
        return result;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("Can't execute after statement has been closed");
        }
        Message query = new Message(230, this.batch, true);
        Message reply = this.mHandler.send(query, this.getConnection().getAutoCommit());
        if (reply.getOpcode() == 232) {
            throw new SQLException("Error executing batch");
        }
        if (reply.getOpcode() == 93) {
            throw new SQLException("Timeout on batch execution");
        }
        if (reply.getOpcode() == 94) {
            throw new SQLException("Transaction aborted");
        }
        this.clearBatch();
        ArrayList result = (ArrayList)reply.getContents();
        int[] returnArray = new int[result.size()];
        int i = 0;
        while (i < returnArray.length) {
            returnArray[i] = (Integer)result.get(i);
            ++i;
        }
        return returnArray;
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 8;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 6;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 4;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = -5;
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 5;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append('\'');
        int i = 0;
        while (i < x.length()) {
            char c = x.charAt(i);
            if (c == '\'') {
                buf.append('\'');
                buf.append('\'');
            } else if (c == '\\') {
                switch (c) {
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'b': {
                        buf.append('\b');
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    default: {
                        buf.append(c);
                        break;
                    }
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        buf.append('\'');
        String cleanX = buf.toString();
        this.parameters.put(parameterIndex, cleanX);
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 12;
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        String efficientTime = this.formatTime(x);
        this.parameters.put(parameterIndex, "'" + efficientTime + "'");
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 92;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        String efficientTime = this.formatTime(x);
        this.parameters.put(parameterIndex, "'" + efficientTime + "'");
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 93;
    }

    @Override
    public void addBatch() throws SQLException {
        this.current = this.updateSql(this.current);
        this.batch.addLast(this.current);
        this.current = this.template;
        this.clearParameters();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch = new LinkedList();
        this.parameters.clear();
        this.current = this.template;
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.timeoutInMillis / 1000;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        this.maxRows = arg0;
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        this.timeoutInMillis = arg0;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setByte(int arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        String efficientTime = this.formatTime(x);
        efficientTime = efficientTime.substring(0, 10);
        this.parameters.put(parameterIndex, "'" + efficientTime + "'");
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 91;
    }

    @Override
    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int parameterIndex, int arg1) throws SQLException {
        this.parameters.put(parameterIndex, "null");
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 0;
    }

    @Override
    public void setNull(int parameterIndex, int arg1, String arg2) throws SQLException {
        this.setNull(parameterIndex, arg1);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.parameterTypes[parameterIndex + this.parameterIndexOffset] = 93;
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(int arg0, URL arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setStatementOption(int statementOption) {
        this.statementOption = statementOption;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return this.generatedKeys;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    private String formatTime(Object value) throws SQLException {
        String timeAsString;
        String formatedTime = timeAsString = value.toString();
        int length = timeAsString.length();
        if (length == 23 && timeAsString.charAt(4) == '-') {
            if (timeAsString.endsWith("00:00:00.000")) {
                formatedTime = timeAsString.substring(0, 10);
            }
        } else if (length == 22 && timeAsString.charAt(4) == '-') {
            if (timeAsString.endsWith("00:00:00.00")) {
                formatedTime = timeAsString.substring(0, 10);
            }
        } else if (length == 21 && timeAsString.charAt(4) == '-') {
            if (timeAsString.endsWith("00:00:00.0")) {
                formatedTime = timeAsString.substring(0, 10);
            }
        } else if (length == 19 && timeAsString.charAt(4) == '-') {
            if (timeAsString.endsWith("00:00:00")) {
                formatedTime = timeAsString.substring(0, 10);
            }
        } else if (length == 16 && timeAsString.charAt(4) == '-' && timeAsString.endsWith("00:00")) {
            formatedTime = timeAsString.substring(0, 10);
        }
        return formatedTime;
    }
}

