/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import lasige.divdb.comm.LoginRequest;
import lasige.divdb.comm.Message;
import lasige.divdb.comm.MessageHandler;
import lasige.divdb.jdbc.BFTConnection;

public class BFTDriver
implements Driver {
    public static final Pattern QUERY_PATTERN = Pattern.compile("^SELECT .*", 34);
    public static final Pattern UPDATE_PATTERN = Pattern.compile("^(INSERT|DELETE|UPDATE) .*", 34);
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private static final AtomicInteger clientId = new AtomicInteger(0);
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"divdb");

    static {
        BFTDriver driver = new BFTDriver();
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:bftdriver");
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        Message login;
        String[] urlData = url.split(";");
        if (!urlData[0].equalsIgnoreCase("jdbc:bftdriver")) {
            return null;
        }
        int replicaCount = urlData.length - 1;
        Vector<String> databases = new Vector<String>(replicaCount);
        int i = 1;
        while (i < urlData.length) {
            databases.add(urlData[i]);
            ++i;
        }
        String[] userList = props.getProperty("user").split(";");
        String[] passList = props.getProperty("password").split(";");
        if (userList.length != replicaCount || passList.length != replicaCount) {
            throw new SQLException("Invalid username or password");
        }
        Vector<String> users = new Vector<String>(replicaCount);
        Vector<String> passwords = new Vector<String>(replicaCount);
        int i2 = 0;
        while (i2 < replicaCount) {
            users.add(userList[i2]);
            passwords.add(passList[i2]);
            ++i2;
        }
        LoginRequest lr = new LoginRequest(databases, users, passwords);
        MessageHandler mHandler = new MessageHandler(clientId.incrementAndGet());
        Message reply = mHandler.send(login = new Message(100, lr, false), true);
        if (reply.getOpcode() != 101) {
            throw new SQLException("Error establishing connection:Invalid username or password");
        }
        BFTConnection connection = new BFTConnection(mHandler);
        connection.setClientInfo("ClientUser", String.valueOf(clientId));
        return connection;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

