/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import lasige.divdb.comm.Message;
import lasige.divdb.comm.MessageHandler;
import lasige.divdb.jdbc.BFTDatabaseMetaData;
import lasige.divdb.jdbc.BFTPreparedStatement;
import lasige.divdb.jdbc.BFTStatement;

public class BFTConnection
implements Connection {
    private MessageHandler mHandler;
    private boolean autoCommit = true;
    private boolean closed = true;
    private Properties clientInfo = new Properties();

    public BFTConnection(MessageHandler mHandler) {
        this.mHandler = mHandler;
        this.closed = false;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        BFTPreparedStatement pstmt = new BFTPreparedStatement(this, this.mHandler, sql);
        return pstmt;
    }

    @Override
    public void close() throws SQLException {
        Message close = new Message(600, null, false);
        Message reply = this.mHandler.send(close, true);
        if (reply.getOpcode() == 602) {
            throw new SQLException("BFTConnection.close() exception");
        }
        this.mHandler.close();
        this.closed = true;
    }

    @Override
    public Statement createStatement() throws SQLException {
        BFTStatement stmt = new BFTStatement(this.mHandler, this);
        return stmt;
    }

    @Override
    public void rollback() throws SQLException {
        Message rollback = new Message(400, null, false);
        Message reply = this.mHandler.send(rollback, false);
        if (reply.getOpcode() == 402) {
            throw new SQLException("Error during rollback");
        }
    }

    @Override
    public void commit() throws SQLException {
        LinkedList hashTable = new LinkedList();
        Message commit = new Message(300, hashTable, false);
        Message reply = this.mHandler.send(commit, false);
        if (reply.getOpcode() == 302) {
            throw new SQLException("Commit Error");
        }
        if (reply.getOpcode() == 93) {
            throw new SQLException("Timeout during commit");
        }
        if (reply.getOpcode() == 94) {
            throw new SQLException("Transaction aborted");
        }
    }

    @Override
    public void setAutoCommit(boolean flag) throws SQLException {
        if (flag != this.autoCommit) {
            Message autoCommitMessage = new Message(303, flag, false);
            Message reply = this.mHandler.send(autoCommitMessage, true);
            if (reply.getOpcode() == 305) {
                throw new SQLException("Error setting auto-commit flag");
            }
            if (reply.getOpcode() == 93) {
                throw new SQLException("Timeout setting auto-commit flag");
            }
            this.autoCommit = flag;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createStatement(int arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Integer clientId = Integer.valueOf(this.getClientInfo("ClientUser"));
        Message metadataMessage = new Message(700, clientId, false);
        Message reply = this.mHandler.send(metadataMessage, true);
        BFTDatabaseMetaData bftDBM = null;
        if (reply.getOpcode() == 701) {
            bftDBM = (BFTDatabaseMetaData)reply.getContents();
        }
        return bftDBM;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        return new BFTPreparedStatement(this, this.mHandler, arg0, arg1);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

