/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.comm;

import bftsmart.communication.client.ReplyListener;
import bftsmart.reconfiguration.ClientViewManager;
import bftsmart.statemanagement.SMMessage;
import bftsmart.statemanagement.strategy.StandardSMMessage;
import bftsmart.tom.ServiceProxy;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Extractor;
import bftsmart.tom.util.TOMUtil;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import lasige.divdb.client.StateRequestListener;
import lasige.divdb.client.SteelDBListener;
import lasige.divdb.comm.FinishTransactionRequest;
import lasige.divdb.comm.Message;
import lasige.divdb.comm.RollbackRequest;
import lasige.divdb.jdbc.BFTRowSet;
import lasige.divdb.jdbc.ResultSetData;
import org.apache.log4j.Logger;

public class MessageHandler {
    private ServiceProxy proxy;
    private boolean transactionReadOnly;
    private LinkedList<byte[]> resHashes;
    private LinkedList<Message> operations;
    private ClientViewManager viewManager;
    private static final String CONFIG_FOLDER = System.getProperty("divdb.folder", "config");
    private static final int FIRST_CLIENT_ID = Integer.valueOf(System.getProperty("divdb.firstclient", "0"));
    private final int clientId;
    private int master;
    private int oldMaster;
    private Logger logger = Logger.getLogger((String)"divdb");

    public MessageHandler(int clientId) {
        clientId = FIRST_CLIENT_ID + clientId;
        this.proxy = new ServiceProxy(clientId, CONFIG_FOLDER, (Comparator)new BFTComparator(), (Extractor)new BFTExtractor());
        this.transactionReadOnly = true;
        this.resHashes = new LinkedList();
        this.operations = new LinkedList();
        this.viewManager = this.proxy.getViewManager();
        this.clientId = clientId;
        this.master = 0;
    }

    public MessageHandler(int clientId, boolean replica) {
        this.proxy = new ServiceProxy(clientId, CONFIG_FOLDER, (Comparator)new BFTComparator(), (Extractor)new BFTExtractor());
        this.transactionReadOnly = true;
        this.viewManager = this.proxy.getViewManager();
        this.clientId = clientId;
        this.master = 0;
    }

    public synchronized Message send(Message m, boolean autoCommit) {
        Message reply;
        Object replyContent;
        try {
            m.setClientId(this.clientId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int opCode = m.getOpcode();
        byte[] response = null;
        if (opCode == 300 || opCode == 400 || opCode == 303 || opCode == 600 || opCode == 100 || opCode == 700) {
            if (opCode == 300 || opCode == 400 || !this.transactionReadOnly && opCode == 303 && Boolean.valueOf(m.getContents().equals(true)).booleanValue()) {
                m = this.prepareFinishTransactionRequest(opCode);
                this.transactionReadOnly = true;
            }
            response = this.proxy.invokeOrdered(m.getBytes());
            if (opCode == 300 || opCode == 400 || !this.transactionReadOnly && opCode == 303 && Boolean.valueOf(m.getContents().equals(true)).booleanValue()) {
                this.clearOpsRes();
            }
        } else if (autoCommit) {
            response = opCode == 210 || opCode == 230 ? this.proxy.invokeOrdered(m.getBytes()) : this.proxy.invokeUnordered(m.getBytes());
        } else {
            if (opCode == 210 || opCode == 230) {
                this.transactionReadOnly = false;
            }
            if (!this.transactionReadOnly) {
                this.operations.add(m);
            }
            int[] processes = new int[]{this.master};
            SteelDBListener steelListener = new SteelDBListener(m.getBytes(), new BFTComparator(), new BFTExtractor(), this.master);
            this.proxy.invokeAsynchronous(m.getBytes(), (ReplyListener)steelListener, processes, TOMMessageType.UNORDERED_REQUEST);
            TOMMessage message = steelListener.getResponse();
            if (message != null) {
                response = message.getContent();
            }
        }
        if ((replyContent = (reply = Message.getMessage(response)).getContents()) instanceof ResultSetData) {
            ResultSetData rsd = (ResultSetData)replyContent;
            try {
                BFTRowSet bftrs = new BFTRowSet();
                bftrs.populate(rsd);
                reply = new Message(reply.getOpcode(), bftrs, reply.isUnordered(), reply.getMaster(), reply.getStatementOption());
            }
            catch (SQLException e) {
                this.logger.error((Object)"Error populating BFTRowSet", (Throwable)e);
            }
        }
        if (!this.transactionReadOnly) {
            byte[] replyBytes = TOMUtil.getBytes((Object)String.valueOf(replyContent));
            byte[] replyHash = TOMUtil.computeHash((byte[])replyBytes);
            if (replyContent instanceof ResultSetData) {
                ResultSetData resultSetData = (ResultSetData)replyContent;
            }
            this.resHashes.add(replyHash);
        }
        return reply;
    }

    public void close() {
        this.proxy.close();
    }

    private int[] getFPlusOneOthers(int operationId, int[] processes) {
        int fPlusOne = this.proxy.getViewManager().getCurrentViewF() + 1;
        int[] target = new int[fPlusOne];
        int counter = 0;
        int index = operationId % processes.length;
        while (counter < fPlusOne) {
            if (processes[index] != this.master) {
                target[counter] = processes[index];
                ++counter;
            }
            index = (index + 1) % processes.length;
        }
        return target;
    }

    public synchronized Message requestState(SMMessage smmsg) {
        byte[] response = null;
        try {
            Message m = new Message(96, smmsg, false);
            m.setClientId(this.clientId);
            this.logger.debug((Object)("---- requesting state up to eid " + smmsg.getEid()));
            StandardSMMessage stdMsg = (StandardSMMessage)smmsg;
            StateRequestListener stateListener = new StateRequestListener(m.getBytes(), stdMsg.getReplica());
            int[] processes = this.viewManager.getCurrentViewProcesses();
            int[] otherProcesses = new int[processes.length - 1];
            int count = 0;
            int[] nArray = processes;
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                int process = nArray[n2];
                if (process != this.clientId) {
                    otherProcesses[count] = process;
                    ++count;
                }
                ++n2;
            }
            this.proxy.invokeAsynchronous(m.getBytes(), (ReplyListener)stateListener, otherProcesses, TOMMessageType.ORDERED_REQUEST);
            TOMMessage message = stateListener.getResponse();
            this.logger.debug((Object)("Message:" + message));
            if (message != null) {
                response = message.getContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Message reply = Message.getMessage(response);
        return reply;
    }

    private Message prepareFinishTransactionRequest(int opcode) {
        Message message;
        FinishTransactionRequest finishReq = new FinishTransactionRequest(this.resHashes, this.operations);
        if (opcode == 400) {
            boolean masterChanged = this.oldMaster != this.master;
            RollbackRequest req = new RollbackRequest(masterChanged, this.oldMaster, finishReq);
            message = new Message(opcode, req, false, this.master);
        } else {
            message = new Message(opcode, finishReq, false, this.master);
        }
        try {
            message.setClientId(this.clientId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    private void clearOpsRes() {
        this.resHashes = new LinkedList();
        this.operations = new LinkedList();
    }

    static class BFTComparator
    implements Comparator<byte[]> {
        BFTComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            Message m1 = Message.getMessage(o1);
            Message m2 = Message.getMessage(o2);
            if (m1.getOpcode() != m2.getOpcode()) {
                return -1;
            }
            if (m1.getContents() instanceof byte[] && m2.getContents() instanceof byte[]) {
                boolean byteArrayEquals = Arrays.equals((byte[])m1.getContents(), (byte[])m2.getContents());
                if (byteArrayEquals) {
                    return 0;
                }
                return -1;
            }
            if (m1.getContents() == null && m2.getContents() == null || m1.getContents().equals(m2.getContents())) {
                return 0;
            }
            return -1;
        }
    }

    static class BFTExtractor
    implements Extractor {
        BFTExtractor() {
        }

        public TOMMessage extractResponse(TOMMessage[] replies, int sameContent, int lastReceived) {
            TOMMessage reply = replies[lastReceived];
            if (reply == null) {
                System.out.println("MessageHandler.extractresponse(): reply at position " + lastReceived + " is null");
            }
            return reply;
        }
    }
}

